/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming;

import forestry.Forestry;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.IFarmRegistry;
import forestry.api.modules.ForestryModule;
import forestry.core.circuits.CircuitLayout;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.features.CoreItems;
import forestry.farming.DummyFarmRegistry;
import forestry.farming.FarmDefinition;
import forestry.farming.FarmRegistry;
import forestry.farming.features.FarmingContainers;
import forestry.farming.gui.GuiFarm;
import forestry.farming.logic.farmables.FarmableAgingCrop;
import forestry.farming.logic.farmables.FarmableChorus;
import forestry.farming.logic.farmables.FarmableGE;
import forestry.farming.logic.farmables.FarmableGourd;
import forestry.farming.logic.farmables.FarmableSapling;
import forestry.farming.logic.farmables.FarmableStacked;
import forestry.farming.proxy.ProxyFarming;
import forestry.farming.proxy.ProxyFarmingClient;
import forestry.modules.BlankForestryModule;
import forestry.modules.ISidedModuleHandler;
import forestry.modules.ModuleHelper;
import java.io.File;
import net.minecraft.block.BeetrootBlock;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;

@ForestryModule(containerID="forestry", moduleID="farming", name="Farming", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.farming.description")
public class ModuleFarming
extends BlankForestryModule {
    public static ProxyFarming proxy;

    public ModuleFarming() {
        proxy = (ProxyFarming)DistExecutor.runForDist(() -> ProxyFarmingClient::new, () -> ProxyFarming::new);
    }

    @Override
    public void setupAPI() {
        ForestryAPI.farmRegistry = FarmRegistry.getInstance();
    }

    @Override
    public void disabledSetupAPI() {
        ForestryAPI.farmRegistry = new DummyFarmRegistry();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerGuiFactories() {
        ScreenManager.func_216911_a(FarmingContainers.FARM.containerType(), GuiFarm::new);
    }

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IFarmRegistry registry = ForestryAPI.farmRegistry;
        registry.registerFarmables("farmArboreal", new FarmableSapling(new ItemStack((IItemProvider)Blocks.field_196674_t), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151034_e), new ItemStack((IItemProvider)Items.field_151055_y)}));
        registry.registerFarmables("farmArboreal", new FarmableSapling(new ItemStack((IItemProvider)Blocks.field_196676_v), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151055_y)}));
        registry.registerFarmables("farmArboreal", new FarmableSapling(new ItemStack((IItemProvider)Blocks.field_196675_u), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151055_y)}));
        registry.registerFarmables("farmArboreal", new FarmableSapling(new ItemStack((IItemProvider)Blocks.field_196678_w), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151055_y), new ItemStack((IItemProvider)Items.field_196130_bo)}));
        registry.registerFarmables("farmArboreal", new FarmableSapling(new ItemStack((IItemProvider)Blocks.field_196680_y), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151055_y)}));
        registry.registerFarmables("farmArboreal", new FarmableSapling(new ItemStack((IItemProvider)Blocks.field_196679_x), new ItemStack[]{new ItemStack((IItemProvider)Items.field_151055_y)}));
        if (ModuleHelper.isEnabled("arboriculture")) {
            registry.registerFarmables("farmArboreal", new FarmableGE());
        }
        registry.registerFarmables("farmCrops", new FarmableAgingCrop(new ItemStack((IItemProvider)Items.field_151014_N), Blocks.field_150464_aj, new ItemStack((IItemProvider)Items.field_151015_O), (Property<Integer>)CropsBlock.field_176488_a, 7, (Integer)0), new FarmableAgingCrop(new ItemStack((IItemProvider)Items.field_151174_bG), Blocks.field_150469_bN, new ItemStack((IItemProvider)Items.field_151174_bG), (Property<Integer>)CropsBlock.field_176488_a, 7, (Integer)0), new FarmableAgingCrop(new ItemStack((IItemProvider)Items.field_151172_bF), Blocks.field_150459_bM, new ItemStack((IItemProvider)Items.field_151172_bF), (Property<Integer>)CropsBlock.field_176488_a, 7, (Integer)0), new FarmableAgingCrop(new ItemStack((IItemProvider)Items.field_185163_cU), Blocks.field_185773_cZ, new ItemStack((IItemProvider)Items.field_185164_cV), (Property<Integer>)BeetrootBlock.field_185531_a, 3, (Integer)0));
        registry.registerFarmables("farmGourd", new FarmableGourd(new ItemStack((IItemProvider)Items.field_151080_bb), Blocks.field_150393_bb, Blocks.field_150423_aK));
        registry.registerFarmables("farmGourd", new FarmableGourd(new ItemStack((IItemProvider)Items.field_151081_bc), Blocks.field_150394_bc, Blocks.field_150440_ba));
        registry.registerFarmables("farmInfernal", new FarmableAgingCrop(new ItemStack((IItemProvider)Items.field_151075_bm), Blocks.field_150388_bm, (Property<Integer>)NetherWartBlock.field_176486_a, 3));
        registry.registerFarmables("farmPoales", new FarmableStacked(new ItemStack((IItemProvider)Items.field_222065_kN), Blocks.field_196608_cF, 3));
        registry.registerFarmables("farmSucculentes", new FarmableStacked(new ItemStack((IItemProvider)Blocks.field_150434_aF), Blocks.field_150434_aF, 3));
        registry.registerFarmables("farmEnder", FarmableChorus.INSTANCE);
        registry.registerFertilizer(CoreItems.FERTILIZER_COMPOUND.stack(), 500);
        CircuitLayout layoutManaged = new CircuitLayout("farms.managed", CircuitSocketType.FARM);
        ChipsetManager.circuitRegistry.registerLayout(layoutManaged);
        CircuitLayout layoutManual = new CircuitLayout("farms.manual", CircuitSocketType.FARM);
        ChipsetManager.circuitRegistry.registerLayout(layoutManual);
    }

    @Override
    public void doInit() {
        File configFile = new File(Forestry.instance.getConfigFolder(), "farm.cfg");
        LocalizedConfiguration config = new LocalizedConfiguration(configFile, "1.0.0");
        FarmRegistry.getInstance().loadConfig(config);
        config.save();
        FarmDefinition.init();
    }

    @Override
    public void registerObjects() {
    }

    @Override
    public void registerRecipes() {
        FarmDefinition.registerCircuits();
    }

    @Override
    public ISidedModuleHandler getModuleHandler() {
        return proxy;
    }
}

