/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.blocks;

import forestry.core.blocks.BlockStructure;
import forestry.farming.blocks.EnumFarmBlockType;
import forestry.farming.blocks.EnumFarmMaterial;
import forestry.farming.tiles.TileFarmControl;
import forestry.farming.tiles.TileFarmGearbox;
import forestry.farming.tiles.TileFarmHatch;
import forestry.farming.tiles.TileFarmPlain;
import forestry.farming.tiles.TileFarmValve;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.ToolType;

public class BlockFarm
extends BlockStructure {
    private final EnumFarmBlockType type;
    private final EnumFarmMaterial farmMaterial;
    public static final EnumProperty<State> STATE = EnumProperty.func_177709_a((String)"state", State.class);

    public BlockFarm(EnumFarmBlockType type, EnumFarmMaterial farmMaterial) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(1.0f).harvestTool(ToolType.PICKAXE).harvestLevel(0));
        this.type = type;
        this.farmMaterial = farmMaterial;
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(STATE, (Comparable)((Object)State.PLAIN)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{STATE});
    }

    public void func_149666_a(ItemGroup tab, NonNullList<ItemStack> list) {
        super.func_149666_a(tab, list);
    }

    public EnumFarmBlockType getType() {
        return this.type;
    }

    public EnumFarmMaterial getFarmMaterial() {
        return this.farmMaterial;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        switch (this.type) {
            case GEARBOX: {
                return new TileFarmGearbox();
            }
            case HATCH: {
                return new TileFarmHatch();
            }
            case VALVE: {
                return new TileFarmValve();
            }
            case CONTROL: {
                return new TileFarmControl();
            }
        }
        return new TileFarmPlain();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return this.getType() == EnumFarmBlockType.CONTROL;
    }

    public static enum State implements IStringSerializable
    {
        PLAIN,
        BAND;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

