/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.blocks;

import forestry.api.core.IBlockSubtype;
import forestry.core.utils.ResourceUtil;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public enum EnumFarmMaterial implements IBlockSubtype
{
    BRICK_STONE(new ItemStack((IItemProvider)Blocks.field_196696_di), TextFormatting.DARK_GRAY, "stone_bricks"),
    BRICK_MOSSY(new ItemStack((IItemProvider)Blocks.field_196698_dj), TextFormatting.DARK_GRAY, "mossy_stone_bricks"),
    BRICK_CRACKED(new ItemStack((IItemProvider)Blocks.field_196700_dk), TextFormatting.DARK_GRAY, "cracked_stone_bricks"),
    BRICK(new ItemStack((IItemProvider)Blocks.field_196584_bK), TextFormatting.GOLD, "bricks"),
    SANDSTONE_SMOOTH(new ItemStack((IItemProvider)Blocks.field_196580_bH), TextFormatting.YELLOW, EnumFarmMaterial.pillarTexture("cut_sandstone", "sandstone_bottom", "sandstone_top")),
    SANDSTONE_CHISELED(new ItemStack((IItemProvider)Blocks.field_196583_aj), TextFormatting.YELLOW, EnumFarmMaterial.pillarTexture("chiseled_sandstone", "sandstone_bottom", "sandstone_top")),
    BRICK_NETHER(new ItemStack((IItemProvider)Blocks.field_196653_dH), TextFormatting.DARK_RED, "nether_bricks"),
    BRICK_CHISELED(new ItemStack((IItemProvider)Blocks.field_196702_dl), TextFormatting.GOLD, "chiseled_stone_bricks"),
    QUARTZ(new ItemStack((IItemProvider)Blocks.field_150371_ca), TextFormatting.WHITE, EnumFarmMaterial.pillarTexture("quartz_block_side", "quartz_block_bottom", "quartz_block_top")),
    QUARTZ_CHISELED(new ItemStack((IItemProvider)Blocks.field_196772_fk), TextFormatting.WHITE, EnumFarmMaterial.pillarTexture("chiseled_quartz_block", "chiseled_quartz_block_top", "chiseled_quartz_block_top")),
    QUARTZ_LINES(new ItemStack((IItemProvider)Blocks.field_196770_fj), TextFormatting.WHITE, EnumFarmMaterial.pillarTexture("quartz_pillar", "chiseled_quartz_block_top", "chiseled_quartz_block_top"));

    private final ItemStack base;
    private final TextFormatting formatting;
    private final Function<Direction, String> texture;

    private EnumFarmMaterial(ItemStack base, TextFormatting formatting, String texture) {
        this(base, formatting, (Direction direction) -> texture);
    }

    private EnumFarmMaterial(ItemStack base, TextFormatting formatting, Function<Direction, String> texture) {
        this.base = base;
        this.formatting = formatting;
        this.texture = texture;
    }

    public TextFormatting getFormatting() {
        return this.formatting;
    }

    private static Function<Direction, String> pillarTexture(String side, String bottom, String top) {
        return direction -> {
            switch (direction) {
                case UP: {
                    return top;
                }
                case DOWN: {
                    return bottom;
                }
            }
            return side;
        };
    }

    public TextureAtlasSprite[] getSprites() {
        TextureAtlasSprite[] textures = new TextureAtlasSprite[6];
        for (Direction direction : Direction.field_199792_n) {
            textures[direction.func_176745_a()] = ResourceUtil.getBlockSprite("block/" + this.texture.apply(direction));
        }
        return textures;
    }

    public void saveToCompound(CompoundNBT compound) {
        compound.func_74768_a("FarmBlock", this.ordinal());
    }

    public ITextComponent getDisplayName() {
        return this.base.func_77973_b().func_200295_i(this.base);
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public ItemStack getBase() {
        return this.base;
    }
}

