/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.compat;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.features.CoreItems;
import forestry.core.recipes.jei.ForestryRecipeCategory;
import forestry.farming.compat.FarmingInfoRecipeWrapper;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class FarmingInfoRecipeCategory
extends ForestryRecipeCategory<FarmingInfoRecipeWrapper> {
    public static final ResourceLocation UID = new ResourceLocation("forestry", "farming");
    private final IDrawable slotDrawable;
    private final IDrawable addition;
    private final IDrawable arrow;
    private final IDrawable icon;

    public FarmingInfoRecipeCategory(IGuiHelper guiHelper) {
        super((IDrawable)guiHelper.createBlankDrawable(144, 90), "for.jei.farming");
        this.slotDrawable = guiHelper.getSlotDrawable();
        ResourceLocation resourceLocation = new ResourceLocation("forestry", "textures/gui/jei/recipes.png");
        this.addition = guiHelper.createDrawable(resourceLocation, 44, 0, 15, 15);
        this.arrow = guiHelper.createDrawable(resourceLocation, 59, 0, 15, 15);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)CoreItems.CIRCUITBOARDS.get(EnumCircuitBoardType.INTRICATE)));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends FarmingInfoRecipeWrapper> getRecipeClass() {
        return FarmingInfoRecipeWrapper.class;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout recipeLayout, FarmingInfoRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List stack;
        int index;
        int y;
        int x;
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        guiItemStacks.init(0, true, 63, 18);
        if (inputs.size() > 0) {
            guiItemStacks.set(0, (List)inputs.get(0));
        }
        for (x = 0; x < 2; ++x) {
            for (y = 0; y < 2; ++y) {
                index = 1 + x + y * 2;
                guiItemStacks.init(index, true, x * 18, 54 + y * 18);
                if (inputs.size() <= index) continue;
                stack = (List)inputs.get(index);
                guiItemStacks.set(index, stack);
            }
        }
        for (x = 0; x < 2; ++x) {
            for (y = 0; y < 2; ++y) {
                index = 5 + x + y * 2;
                guiItemStacks.init(index, true, 54 + x * 18, 54 + y * 18);
                if (inputs.size() <= index) continue;
                stack = (List)inputs.get(index);
                guiItemStacks.set(index, stack);
            }
        }
        for (x = 0; x < 2; ++x) {
            for (y = 0; y < 2; ++y) {
                index = 9 + x + y * 2;
                guiItemStacks.init(index, false, 108 + x * 18, 54 + y * 18);
                if (outputs.size() <= x + y * 2) continue;
                stack = (List)outputs.get(x + y * 2);
                guiItemStacks.set(index, stack);
            }
        }
    }

    public void draw(FarmingInfoRecipeWrapper recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        int y;
        int x;
        this.slotDrawable.draw(matrixStack, 63, 18);
        for (x = 0; x < 2; ++x) {
            for (y = 0; y < 2; ++y) {
                this.slotDrawable.draw(matrixStack, x * 18, 54 + y * 18);
            }
        }
        this.addition.draw(matrixStack, 37, 64);
        for (x = 0; x < 2; ++x) {
            for (y = 0; y < 2; ++y) {
                this.slotDrawable.draw(matrixStack, 54 + x * 18, 54 + y * 18);
            }
        }
        this.arrow.draw(matrixStack, 91, 64);
        for (x = 0; x < 2; ++x) {
            for (y = 0; y < 2; ++y) {
                this.slotDrawable.draw(matrixStack, 108 + x * 18, 54 + y * 18);
            }
        }
        int recipeWidth = this.getBackground().getWidth();
        int recipeHeight = this.getBackground().getHeight();
        recipe.drawInfo(recipeWidth, recipeHeight, matrixStack, mouseX, mouseY);
    }
}

