/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.compat;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.api.circuits.ICircuit;
import forestry.api.farming.IFarmProperties;
import forestry.api.farming.IFarmableInfo;
import forestry.api.farming.Soil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class FarmingInfoRecipeWrapper
implements IRecipeCategoryExtension {
    private final ItemStack tube;
    private final IFarmProperties properties;
    private final ICircuit circuit;

    public FarmingInfoRecipeWrapper(ItemStack tube, IFarmProperties properties, ICircuit circuit) {
        this.tube = tube;
        this.properties = properties;
        this.circuit = circuit;
    }

    private static <T> void splitItems(List<List<ItemStack>> items, int startIndex, List<T> values, Function<T, ItemStack> itemFunction) {
        int count = values.size();
        if (count == 0 || count % 4 != 0) {
            count += 4 - count % 4;
        }
        for (int i = 0; i < count; ++i) {
            int index = startIndex + i % 4;
            ItemStack stack = values.size() > i ? itemFunction.apply(values.get(i)) : null;
            FarmingInfoRecipeWrapper.addItemToList(items, index, stack);
        }
    }

    private static void addItemToList(List<List<ItemStack>> items, int index, @Nullable ItemStack stack) {
        List<Object> itemList;
        if (items.size() > index) {
            itemList = items.get(index);
            if (itemList == null) {
                itemList = new ArrayList();
                items.set(index, itemList);
            }
        } else {
            itemList = new ArrayList();
            items.add(itemList);
        }
        if (stack != null) {
            itemList.add(stack);
        }
    }

    public void setIngredients(IIngredients ingredients) {
        ArrayList<List<ItemStack>> inputStacks = new ArrayList<List<ItemStack>>(9);
        ArrayList<List<ItemStack>> outputStacks = new ArrayList<List<ItemStack>>(4);
        inputStacks.add(Collections.singletonList(this.tube));
        ArrayList<Soil> soils = new ArrayList<Soil>(this.properties.getSoils());
        FarmingInfoRecipeWrapper.splitItems(inputStacks, 1, soils, Soil::getResource);
        Collection<IFarmableInfo> farmableInfo = this.properties.getFarmableInfo();
        List germlings = farmableInfo.stream().map(IFarmableInfo::getSeedlings).flatMap(Collection::stream).collect(Collectors.toList());
        FarmingInfoRecipeWrapper.splitItems(inputStacks, 5, germlings, item -> item);
        List productions = farmableInfo.stream().map(IFarmableInfo::getProducts).flatMap(Collection::stream).collect(Collectors.toList());
        FarmingInfoRecipeWrapper.splitItems(outputStacks, 0, productions, item -> item);
        ingredients.setInputLists(VanillaTypes.ITEM, inputStacks);
        ingredients.setOutputLists(VanillaTypes.ITEM, outputStacks);
    }

    public void drawInfo(int recipeWidth, int recipeHeight, MatrixStack matrixStack, double mouseX, double mouseY) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_243248_b(matrixStack, this.circuit.getDisplayName(), (float)(recipeWidth - fontRenderer.func_78256_a(this.circuit.getDisplayName().getString())) / 2.0f, 3.0f, Color.darkGray.getRGB());
        TranslationTextComponent soilName = new TranslationTextComponent("for.jei.farming.soil");
        fontRenderer.func_243248_b(matrixStack, (ITextComponent)soilName, 18.0f - (float)fontRenderer.func_78256_a(soilName.getString()) / 2.0f, 45.0f, Color.darkGray.getRGB());
        TranslationTextComponent germlingsName = new TranslationTextComponent("for.jei.farming.germlings");
        fontRenderer.func_243248_b(matrixStack, (ITextComponent)germlingsName, (float)(recipeWidth - fontRenderer.func_78256_a(germlingsName.getString())) / 2.0f, 45.0f, Color.darkGray.getRGB());
        TranslationTextComponent productsName = new TranslationTextComponent("for.jei.farming.products");
        fontRenderer.func_243248_b(matrixStack, (ITextComponent)productsName, 126.0f - (float)fontRenderer.func_78256_a(productsName.getString()) / 2.0f, 45.0f, Color.darkGray.getRGB());
    }
}

