/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.compat;

import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.features.CoreItems;
import forestry.core.utils.ClientUtils;
import forestry.farming.compat.FarmingInfoRecipeCategory;
import forestry.farming.compat.FarmingInfoRecipeMaker;
import forestry.modules.ModuleHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@JeiPlugin
public class FarmingJeiPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("forestry", "farming");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        if (!ModuleHelper.isEnabled("farming")) {
            return;
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (!ModuleHelper.isEnabled("farming")) {
            return;
        }
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new FarmingInfoRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (!ModuleHelper.isEnabled("farming")) {
            return;
        }
        RecipeManager recipeManager = ClientUtils.getRecipeManager();
        registration.addRecipes(FarmingInfoRecipeMaker.getRecipes(recipeManager), FarmingInfoRecipeCategory.UID);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)CoreItems.CIRCUITBOARDS.get(EnumCircuitBoardType.INTRICATE)), new ResourceLocation[]{FarmingInfoRecipeCategory.UID});
    }
}

