/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.utils.ResourceUtil;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Translator;
import forestry.farming.gui.IFarmLedgerDelegate;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FarmLedger
extends Ledger {
    private final IFarmLedgerDelegate delegate;

    public FarmLedger(LedgerManager ledgerManager, IFarmLedgerDelegate delegate) {
        super(ledgerManager, "farm");
        this.delegate = delegate;
        int titleHeight = StringUtil.getLineHeight(this.maxTextWidth, new ITextProperties[]{this.getTooltip()});
        this.maxHeight = titleHeight + 110;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack transform, int y, int x) {
        this.drawBackground(transform, y, x);
        int xIcon = x + 3;
        int xBody = x + 10;
        int xHeader = x + 22;
        TextureAtlasSprite textureAtlasSprite = ResourceUtil.getBlockSprite("item/water_bucket");
        this.drawSprite(transform, textureAtlasSprite, xIcon, y += 4, AtlasTexture.field_110575_b);
        y += 4;
        if (!this.isFullyOpened()) {
            return;
        }
        y += this.drawHeader(transform, Translator.translateToLocal("for.gui.hydration"), xHeader, y);
        y += 4;
        y += this.drawSubheader(transform, Translator.translateToLocal("for.gui.hydr.heat") + ':', xBody, y);
        y += 3;
        y += this.drawText(transform, StringUtil.floatAsPercent(this.delegate.getHydrationTempModifier()), xBody, y);
        y += 3;
        y += this.drawSubheader(transform, Translator.translateToLocal("for.gui.hydr.humid") + ':', xBody, y);
        y += 3;
        y += this.drawText(transform, StringUtil.floatAsPercent(this.delegate.getHydrationHumidModifier()), xBody, y);
        y += 3;
        y += this.drawSubheader(transform, Translator.translateToLocal("for.gui.hydr.rainfall") + ':', xBody, y);
        y += 3;
        y += this.drawText(transform, StringUtil.floatAsPercent(this.delegate.getHydrationRainfallModifier()) + " (" + this.delegate.getDrought() + " d)", xBody, y);
        y += 3;
        y += this.drawSubheader(transform, Translator.translateToLocal("for.gui.hydr.overall") + ':', xBody, y);
        this.drawText(transform, StringUtil.floatAsPercent(this.delegate.getHydrationModifier()), xBody, y += 3);
    }

    @Override
    public ITextComponent getTooltip() {
        float hydrationModifier = this.delegate.getHydrationModifier();
        return new StringTextComponent(StringUtil.floatAsPercent(hydrationModifier) + ' ').func_230529_a_((ITextComponent)new TranslationTextComponent("for.gui.hydration"));
    }
}

