/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.api.core.tooltips.ToolTip;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmProperties;
import forestry.core.config.Config;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.farming.multiblock.IFarmControllerInternal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class FarmLogicSlot
extends Widget {
    private final IFarmControllerInternal farmController;
    private final FarmDirection farmDirection;
    protected final ToolTip toolTip = new ToolTip(250){

        @Override
        public void refresh() {
            FarmLogicSlot.this.toolTip.clear();
            FarmLogicSlot.this.toolTip.add(FarmLogicSlot.this.getProperties().getDisplayName(FarmLogicSlot.this.getLogic().isManual()));
            FarmLogicSlot.this.toolTip.add((ITextComponent)new TranslationTextComponent("for.gui.farm.fertilizer", new Object[]{Math.round((float)FarmLogicSlot.this.getProperties().getFertilizerConsumption(FarmLogicSlot.this.farmController) * Config.fertilizerModifier)}));
            FarmLogicSlot.this.toolTip.add((ITextComponent)new TranslationTextComponent("for.gui.farm.water", new Object[]{FarmLogicSlot.this.getProperties().getWaterConsumption(FarmLogicSlot.this.farmController, FarmLogicSlot.this.farmController.getFarmLedgerDelegate().getHydrationModifier())}));
        }
    };

    public FarmLogicSlot(IFarmControllerInternal farmController, WidgetManager manager, int xPos, int yPos, FarmDirection farmDirection) {
        super(manager, xPos, yPos);
        this.farmController = farmController;
        this.farmDirection = farmDirection;
    }

    private IFarmLogic getLogic() {
        return this.farmController.getFarmLogic(this.farmDirection);
    }

    private IFarmProperties getProperties() {
        return this.getLogic().getProperties();
    }

    private ItemStack getStackIndex() {
        return this.getProperties().getIcon();
    }

    @Override
    public void draw(MatrixStack transform, int startY, int startX) {
        if (!this.getStackIndex().func_190926_b()) {
            Minecraft minecraft = Minecraft.func_71410_x();
            TextureManager textureManager = minecraft.func_110434_K();
            textureManager.func_110577_a(AtlasTexture.field_110575_b);
            ItemRenderer renderItem = minecraft.func_175599_af();
            renderItem.func_175042_a(this.getStackIndex(), startX + this.xPos, startY + this.yPos);
        }
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            return this.toolTip;
        }
        return null;
    }
}

