/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.api.farming.FarmDirection;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.widgets.SocketWidget;
import forestry.core.gui.widgets.TankWidget;
import forestry.farming.gui.ContainerFarm;
import forestry.farming.gui.FarmLedger;
import forestry.farming.gui.FarmLogicSlot;
import forestry.farming.multiblock.IFarmControllerInternal;
import forestry.farming.multiblock.MultiblockLogicFarm;
import forestry.farming.tiles.TileFarm;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiFarm
extends GuiForestryTitled<ContainerFarm> {
    private final TileFarm tile;

    public GuiFarm(ContainerFarm container, PlayerInventory inv, ITextComponent title) {
        super("textures/gui/mfarm.png", container, inv, title);
        this.tile = (TileFarm)container.getTile();
        this.widgetManager.add(new TankWidget(this.widgetManager, 15, 19, 0).setOverlayOrigin(216, 18));
        this.widgetManager.add(new SocketWidget(this.widgetManager, 69, 40, this.tile, 0));
        IFarmControllerInternal farmController = ((MultiblockLogicFarm)this.tile.getMultiblockLogic()).getController();
        this.widgetManager.add(new FarmLogicSlot(farmController, this.widgetManager, 69, 22, FarmDirection.NORTH));
        this.widgetManager.add(new FarmLogicSlot(farmController, this.widgetManager, 69, 58, FarmDirection.SOUTH));
        this.widgetManager.add(new FarmLogicSlot(farmController, this.widgetManager, 51, 40, FarmDirection.WEST));
        this.widgetManager.add(new FarmLogicSlot(farmController, this.widgetManager, 87, 40, FarmDirection.EAST));
        this.field_146999_f = 216;
        this.field_147000_g = 220;
    }

    @Override
    protected void addLedgers() {
        IFarmControllerInternal farmController = ((MultiblockLogicFarm)this.tile.getMultiblockLogic()).getController();
        this.addErrorLedger(farmController);
        this.addClimateLedger(farmController);
        this.ledgerManager.add(new FarmLedger(this.ledgerManager, farmController.getFarmLedgerDelegate()));
        this.addHintLedger("farm");
    }

    @Override
    protected void func_230450_a_(MatrixStack transform, float partialTicks, int mouseY, int mouseX) {
        super.func_230450_a_(transform, partialTicks, mouseY, mouseX);
        int fertilizerRemain = ((MultiblockLogicFarm)this.tile.getMultiblockLogic()).getController().getStoredFertilizerScaled(16);
        if (fertilizerRemain > 0) {
            this.func_238474_b_(transform, this.field_147003_i + 81, this.field_147009_r + 94 + 17 - fertilizerRemain, this.field_146999_f, 17 - fertilizerRemain, 4, fertilizerRemain);
        }
    }
}

