/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic.crops;

import forestry.core.network.packets.PacketFXSignal;
import forestry.core.utils.NetworkUtil;
import forestry.farming.logic.crops.Crop;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CropBasicGrowthCraft
extends Crop {
    private final BlockState blockState;
    private final boolean isRice;
    private final boolean isGrape;

    public CropBasicGrowthCraft(World world, BlockState blockState, BlockPos position, boolean isRice, boolean isGrape) {
        super(world, position);
        this.blockState = blockState;
        this.isRice = isRice;
        this.isGrape = isGrape;
    }

    @Override
    protected boolean isCrop(World world, BlockPos pos) {
        return world.func_180495_p(pos) == this.blockState;
    }

    @Override
    protected NonNullList<ItemStack> harvestBlock(World world, BlockPos pos) {
        Block block = this.blockState.func_177230_c();
        NonNullList harvest = NonNullList.func_191196_a();
        LootContext.Builder ctx = new LootContext.Builder((ServerWorld)world).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos));
        harvest.addAll((Collection)block.func_220076_a(this.blockState, ctx));
        if (harvest.size() > 1) {
            harvest.remove(0);
        }
        PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, this.blockState);
        NetworkUtil.sendNetworkPacket(packet, pos, world);
        if (this.isGrape) {
            world.func_217377_a(pos, false);
        } else {
            world.func_180501_a(pos, block.func_176223_P(), 2);
        }
        if (this.isRice) {
            world.func_180501_a(pos.func_177977_b(), block.func_176223_P(), 2);
        }
        return harvest;
    }

    public String toString() {
        return String.format("CropBasicGrowthCraft [ position: [ %s ]; block: %s ]", this.position.toString(), this.blockState);
    }
}

