/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic.crops;

import forestry.core.network.packets.PacketFXSignal;
import forestry.core.utils.NetworkUtil;
import forestry.farming.logic.crops.Crop;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CropDestroyDouble
extends Crop {
    protected final BlockState blockState;
    protected final BlockState blockStateUp;
    @Nullable
    protected final BlockState replantState;

    public CropDestroyDouble(World world, BlockState blockState, BlockState blockStateUp, BlockPos position, @Nullable BlockState replantState) {
        super(world, position);
        this.blockState = blockState;
        this.blockStateUp = blockStateUp;
        this.replantState = replantState;
    }

    @Override
    protected boolean isCrop(World world, BlockPos pos) {
        return world.func_180495_p(pos) == this.blockState;
    }

    @Override
    protected NonNullList<ItemStack> harvestBlock(World world, BlockPos pos) {
        Block block = this.blockState.func_177230_c();
        Block blockUp = this.blockStateUp.func_177230_c();
        NonNullList harvested = NonNullList.func_191196_a();
        PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, this.blockState);
        NetworkUtil.sendNetworkPacket(packet, pos, world);
        world.func_217377_a(pos.func_177984_a(), false);
        if (this.replantState != null) {
            world.func_180501_a(pos, this.replantState, 2);
        } else {
            world.func_217377_a(pos, false);
        }
        return harvested;
    }

    public String toString() {
        return String.format("CropDestroyDouble [ position: [ %s ]; block: %s ]", this.position.toString(), this.blockState);
    }
}

