/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic.crops;

import forestry.api.genetics.IFruitBearer;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.NetworkUtil;
import forestry.farming.logic.crops.Crop;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class CropFruit
extends Crop {
    public CropFruit(World world, BlockPos position) {
        super(world, position);
    }

    @Override
    protected boolean isCrop(World world, BlockPos pos) {
        IFruitBearer bearer = TileUtil.getTile((IBlockReader)world, pos, IFruitBearer.class);
        return bearer != null && bearer.hasFruit() && bearer.getRipeness() >= 0.9f;
    }

    @Override
    protected NonNullList<ItemStack> harvestBlock(World world, BlockPos pos) {
        IFruitBearer tile = TileUtil.getTile((IBlockReader)world, pos, IFruitBearer.class);
        if (tile == null) {
            return NonNullList.func_191196_a();
        }
        BlockState blockState = world.func_180495_p(pos);
        PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, blockState);
        NetworkUtil.sendNetworkPacket(packet, pos, world);
        return tile.pickFruit(ItemStack.field_190927_a);
    }
}

