/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic.farmables;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.api.farming.IFarmableInfo;
import forestry.core.utils.BlockUtil;
import forestry.farming.logic.crops.CropDestroy;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class FarmableBase
implements IFarmable {
    protected final ItemStack germling;
    protected final BlockState plantedState;
    protected final BlockState matureState;
    protected final boolean replant;

    public FarmableBase(ItemStack germling, BlockState plantedState, BlockState matureState, boolean replant) {
        this.germling = germling;
        this.plantedState = plantedState;
        this.matureState = matureState;
        this.replant = replant;
    }

    @Override
    public boolean isSaplingAt(World world, BlockPos pos, BlockState blockState) {
        return blockState.func_177230_c() == this.plantedState.func_177230_c() && blockState != this.matureState;
    }

    @Override
    public ICrop getCropAt(World world, BlockPos pos, BlockState blockState) {
        if (blockState != this.matureState) {
            return null;
        }
        BlockState replantState = this.replant ? this.plantedState : null;
        return new CropDestroy(world, blockState, pos, replantState);
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return ItemStack.func_179545_c((ItemStack)this.germling, (ItemStack)itemstack);
    }

    @Override
    public void addInformation(IFarmableInfo info) {
        info.addSeedlings(this.germling);
    }

    @Override
    public boolean plantSaplingAt(PlayerEntity player, ItemStack germling, World world, BlockPos pos) {
        return BlockUtil.setBlockWithPlaceSound(world, pos, this.plantedState);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }
}

