/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic.farmables;

import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.ITreeRoot;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.api.genetics.alleles.AlleleManager;
import forestry.api.genetics.products.Product;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.farming.logic.crops.CropDestroy;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmableGE
implements IFarmable {
    private final Set<Item> windfall = new HashSet<Item>();

    public FarmableGE() {
        this.windfall.addAll(AlleleManager.geneticRegistry.getRegisteredFruitFamilies().values().stream().map(TreeManager.treeRoot::getFruitProvidersForFruitFamily).flatMap(Collection::stream).flatMap(p -> Stream.concat(p.getProducts().getPossibleProducts().stream(), p.getSpecialty().getPossibleProducts().stream())).map(Product::getItem).collect(Collectors.toSet()));
    }

    @Override
    public boolean isSaplingAt(World world, BlockPos pos, BlockState blockState) {
        return ArboricultureBlocks.SAPLING_GE.blockEqual(blockState);
    }

    @Override
    @Nullable
    public ICrop getCropAt(World world, BlockPos pos, BlockState blockState) {
        Block block = blockState.func_177230_c();
        if (!block.func_203417_a((ITag)BlockTags.field_200031_h)) {
            return null;
        }
        return new CropDestroy(world, blockState, pos, null);
    }

    @Override
    public boolean plantSaplingAt(PlayerEntity player, ItemStack germling, World world, BlockPos pos) {
        ITreeRoot treeRoot = TreeManager.treeRoot;
        ITree tree = treeRoot.create(germling).orElse(null);
        return tree != null && treeRoot.plantSapling(world, tree, player.func_146103_bH(), pos);
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return TreeManager.treeRoot.isMember(itemstack);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return this.windfall.contains(itemstack.func_77973_b());
    }
}

