/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic.farmables;

import com.google.common.base.Preconditions;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.farming.logic.crops.CropDestroy;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmableRusticGrape
implements IFarmable {
    public static final BooleanProperty GRAPES = BooleanProperty.func_177716_a((String)"grapes");
    private final Block cropBlock;

    public FarmableRusticGrape(Block cropBlock) {
        Preconditions.checkNotNull((Object)cropBlock);
        this.cropBlock = cropBlock;
    }

    @Override
    public boolean isSaplingAt(World world, BlockPos pos, BlockState blockState) {
        return blockState.func_177230_c() == this.cropBlock;
    }

    @Override
    @Nullable
    public ICrop getCropAt(World world, BlockPos pos, BlockState blockState) {
        if (blockState.func_177230_c() != this.cropBlock) {
            return null;
        }
        if (!((Boolean)blockState.func_177229_b((Property)GRAPES)).booleanValue()) {
            return null;
        }
        BlockState replantState = this.getReplantState(blockState);
        return new CropDestroy(world, blockState, pos, replantState);
    }

    @Nullable
    protected BlockState getReplantState(BlockState blockState) {
        return (BlockState)blockState.func_206870_a((Property)GRAPES, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean plantSaplingAt(PlayerEntity player, ItemStack germling, World world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }
}

