/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic.farmables;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.api.farming.IFarmableInfo;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.NetworkUtil;
import forestry.farming.logic.crops.CropDestroy;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class FarmableSapling
implements IFarmable {
    protected final ItemStack germling;
    protected final Block saplingBlock;
    protected final ItemStack[] windfall;

    public FarmableSapling(ItemStack germling, ItemStack[] windfall) {
        this.germling = germling;
        this.windfall = windfall;
        this.saplingBlock = ItemStackUtil.getBlock(germling);
    }

    @Override
    public boolean plantSaplingAt(PlayerEntity player, ItemStack germling, World world, BlockPos pos) {
        ItemStack copy = germling.func_77946_l();
        player.func_184611_a(Hand.MAIN_HAND, copy);
        BlockRayTraceResult result = new BlockRayTraceResult(Vector3d.field_186680_a, Direction.UP, pos.func_177977_b(), true);
        ActionResultType actionResult = copy.func_196084_a(new ItemUseContext(player, Hand.MAIN_HAND, result));
        player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        if (actionResult.func_226246_a_()) {
            PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.SoundFXType.BLOCK_PLACE, pos, Blocks.field_196674_t.func_176223_P());
            NetworkUtil.sendNetworkPacket(packet, pos, world);
            return true;
        }
        return false;
    }

    @Override
    public boolean isSaplingAt(World world, BlockPos pos, BlockState blockState) {
        return blockState.func_177230_c() == this.saplingBlock;
    }

    @Override
    public ICrop getCropAt(World world, BlockPos pos, BlockState blockState) {
        Block block = blockState.func_177230_c();
        if (!block.func_203417_a((ITag)BlockTags.field_200031_h)) {
            return null;
        }
        return new CropDestroy(world, blockState, pos, null);
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return ItemStack.func_179545_c((ItemStack)this.germling, (ItemStack)new ItemStack((IItemProvider)itemstack.func_77973_b()));
    }

    @Override
    public void addInformation(IFarmableInfo info) {
        NonNullList germlings = NonNullList.func_191196_a();
        Item germlingItem = this.germling.func_77973_b();
        ItemGroup tab = germlingItem.func_77640_w();
        if (tab != null) {
            germlingItem.func_150895_a(tab, germlings);
        }
        if (germlings.isEmpty()) {
            germlings.add((Object)this.germling);
        }
        info.addSeedlings((Collection<ItemStack>)germlings);
        info.addProducts(this.windfall);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        for (ItemStack drop : this.windfall) {
            if (!drop.func_77969_a(itemstack)) continue;
            return true;
        }
        return false;
    }
}

