/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.multiblock;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitSocketType;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmable;
import forestry.api.multiblock.IFarmComponent;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.config.Config;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.TankManager;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.multiblock.IMultiblockControllerInternal;
import forestry.core.multiblock.MultiblockValidationException;
import forestry.core.multiblock.RectangularMultiblockControllerBase;
import forestry.core.network.PacketBufferForestry;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.utils.PlayerUtil;
import forestry.core.utils.Translator;
import forestry.farming.FarmDefinition;
import forestry.farming.FarmHelper;
import forestry.farming.FarmManager;
import forestry.farming.FarmTarget;
import forestry.farming.gui.IFarmLedgerDelegate;
import forestry.farming.multiblock.FarmMultiblockSizeLimits;
import forestry.farming.multiblock.IFarmControllerInternal;
import forestry.farming.multiblock.IFarmInventoryInternal;
import forestry.farming.multiblock.InventoryFarm;
import forestry.farming.tiles.TileFarmGearbox;
import forestry.farming.tiles.TileFarmPlain;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class FarmController
extends RectangularMultiblockControllerBase
implements IFarmControllerInternal,
ILiquidTankTile {
    private int allowedExtent = 0;
    private final Map<IFarmComponent.Active, Integer> farmActiveComponents = new HashMap<IFarmComponent.Active, Integer>();
    private final Map<FarmDirection, IFarmLogic> farmLogics = new EnumMap<FarmDirection, IFarmLogic>(FarmDirection.class);
    private final InventoryAdapter sockets;
    private final InventoryFarm inventory = new InventoryFarm(this);
    private final FarmManager manager = new FarmManager(this);
    private int noPowerTime = 0;
    @Nullable
    private Vector3i offset;
    @Nullable
    private Vector3i area;

    public FarmController(World world) {
        super(world, FarmMultiblockSizeLimits.instance);
        this.sockets = new InventoryAdapter(1, "sockets");
        this.refreshFarmLogics();
    }

    @Override
    public IFarmLedgerDelegate getFarmLedgerDelegate() {
        return this.manager.getHydrationManager();
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        if (this.isAssembled()) {
            return this.inventory;
        }
        return FakeInventoryAdapter.instance();
    }

    @Override
    public TankManager getTankManager() {
        return this.manager.getTankManager();
    }

    @Override
    public void onAttachedPartWithMultiblockData(IMultiblockComponent part, CompoundNBT data) {
        this.read(data);
    }

    @Override
    protected void onBlockAdded(IMultiblockComponent newPart) {
        if (newPart instanceof IFarmComponent.Listener) {
            IFarmComponent.Listener listenerPart = (IFarmComponent.Listener)newPart;
            this.manager.addListener(listenerPart.getFarmListener());
        }
        if (newPart instanceof IFarmComponent.Active) {
            this.farmActiveComponents.put((IFarmComponent.Active)newPart, this.world.field_73012_v.nextInt(256));
        }
    }

    @Override
    protected void onBlockRemoved(IMultiblockComponent oldPart) {
        if (oldPart instanceof IFarmComponent.Listener) {
            IFarmComponent.Listener listenerPart = (IFarmComponent.Listener)oldPart;
            this.manager.removeListener(listenerPart.getFarmListener());
        }
        if (oldPart instanceof IFarmComponent.Active) {
            this.farmActiveComponents.remove(oldPart);
        }
    }

    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        super.isMachineWhole();
        boolean hasGearbox = false;
        for (IMultiblockComponent part : this.connectedParts) {
            if (!(part instanceof TileFarmGearbox)) continue;
            hasGearbox = true;
            break;
        }
        if (!hasGearbox) {
            throw new MultiblockValidationException(Translator.translateToLocal("for.multiblock.farm.error.needGearbox"));
        }
    }

    @Override
    protected void onMachineDisassembled() {
        super.onMachineDisassembled();
        this.manager.clearTargets();
    }

    @Override
    public void isGoodForExteriorLevel(IMultiblockComponent part, int level) throws MultiblockValidationException {
        if (level == 2 && !(part instanceof TileFarmPlain)) {
            throw new MultiblockValidationException(Translator.translateToLocal("for.multiblock.farm.error.needPlainBand"));
        }
    }

    @Override
    public void isGoodForInterior(IMultiblockComponent part) throws MultiblockValidationException {
        if (!(part instanceof TileFarmPlain)) {
            throw new MultiblockValidationException(Translator.translateToLocal("for.multiblock.farm.error.needPlainInterior"));
        }
    }

    @Override
    public void onAssimilate(IMultiblockControllerInternal assimilated) {
    }

    @Override
    public void onAssimilated(IMultiblockControllerInternal assimilator) {
    }

    @Override
    protected boolean updateServer(int tickCount) {
        this.manager.getHydrationManager().updateServer();
        if (this.updateOnInterval(20)) {
            this.inventory.drainCan(this.manager.getTankManager());
        }
        boolean hasPower = false;
        for (Map.Entry<IFarmComponent.Active, Integer> entry : this.farmActiveComponents.entrySet()) {
            IFarmComponent.Active farmComponent = entry.getKey();
            if (farmComponent instanceof TileFarmGearbox) {
                hasPower |= ((TileFarmGearbox)farmComponent).getEnergyManager().getEnergyStored() > 0;
            }
            int tickOffset = entry.getValue();
            farmComponent.updateServer(tickCount + tickOffset);
        }
        if (hasPower) {
            this.noPowerTime = 0;
            this.getErrorLogic().setCondition(false, EnumErrorCode.NO_POWER);
        } else if (this.noPowerTime <= 4) {
            ++this.noPowerTime;
        } else {
            this.getErrorLogic().setCondition(true, EnumErrorCode.NO_POWER);
        }
        return true;
    }

    @Override
    protected void updateClient(int tickCount) {
        for (Map.Entry<IFarmComponent.Active, Integer> entry : this.farmActiveComponents.entrySet()) {
            IFarmComponent.Active farmComponent = entry.getKey();
            int tickOffset = entry.getValue();
            farmComponent.updateClient(tickCount + tickOffset);
        }
    }

    @Override
    public CompoundNBT write(CompoundNBT data) {
        data = super.write(data);
        this.sockets.write(data);
        this.manager.write(data);
        this.inventory.write(data);
        return data;
    }

    @Override
    public void read(CompoundNBT data) {
        super.read(data);
        this.sockets.read(data);
        this.manager.read(data);
        this.inventory.read(data);
        this.refreshFarmLogics();
    }

    @Override
    public void formatDescriptionPacket(CompoundNBT data) {
        this.sockets.write(data);
        this.manager.write(data);
    }

    @Override
    public void decodeDescriptionPacket(CompoundNBT data) {
        this.sockets.read(data);
        this.manager.read(data);
        this.refreshFarmLogics();
    }

    @Override
    public BlockPos getCoordinates() {
        return this.getReferenceCoord();
    }

    @Override
    public BlockPos getTopCoord() {
        return this.getTopCenterCoord();
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        this.manager.writeData(data);
        this.sockets.writeData(data);
    }

    @Override
    public void readGuiData(PacketBufferForestry data) throws IOException {
        this.manager.readData(data);
        this.sockets.readData(data);
        this.refreshFarmLogics();
    }

    private void refreshFarmLogics() {
        ICircuitBoard chipset;
        for (FarmDirection direction : FarmDirection.values()) {
            this.resetFarmLogic(direction);
        }
        ItemStack chip = this.sockets.func_70301_a(0);
        if (!chip.func_190926_b() && (chipset = ChipsetManager.circuitRegistry.getCircuitBoard(chip)) != null) {
            chipset.onLoad(this);
        }
    }

    @Override
    public EnumTemperature getTemperature() {
        BlockPos coords = this.getReferenceCoord();
        return EnumTemperature.getFromBiome(this.getBiome(), coords);
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    public float getExactTemperature() {
        BlockPos coords = this.getReferenceCoord();
        return this.getBiome().func_225486_c(coords);
    }

    @Override
    public float getExactHumidity() {
        return this.getBiome().func_76727_i();
    }

    protected Biome getBiome() {
        BlockPos coords = this.getReferenceCoord();
        if (coords == null) {
            return (Biome)Objects.requireNonNull(ForgeRegistries.BIOMES.getValue(Biomes.field_76772_c.getRegistryName()));
        }
        return this.world.func_226691_t_(coords);
    }

    @Override
    public BlockPos getCoords() {
        return this.getCenterCoord();
    }

    @Override
    public Vector3i getOffset() {
        if (this.offset == null) {
            Vector3i area = this.getArea();
            this.offset = new Vector3i(-area.func_177958_n() / 2, -2, -area.func_177952_p() / 2);
        }
        return this.offset;
    }

    @Override
    public Vector3i getArea() {
        if (this.area == null) {
            this.area = new Vector3i(7 + this.allowedExtent * 2, 13, 7 + this.allowedExtent * 2);
        }
        return this.area;
    }

    @Override
    public String getUnlocalizedType() {
        return "for.multiblock.farm.type";
    }

    @Override
    public boolean doWork() {
        return this.manager.doWork();
    }

    @Override
    public void setUpFarmlandTargets(Map<FarmDirection, List<FarmTarget>> targets) {
        BlockPos targetStart = this.getCoords();
        BlockPos max = this.getMaximumCoord();
        BlockPos min = this.getMinimumCoord();
        int sizeNorthSouth = Math.abs(max.func_177952_p() - min.func_177952_p()) + 1;
        int sizeEastWest = Math.abs(max.func_177958_n() - min.func_177958_n()) + 1;
        this.allowedExtent = Math.max(sizeNorthSouth, sizeEastWest) * Config.farmSize + 1;
        FarmHelper.createTargets(this.world, this, targets, targetStart, this.allowedExtent, sizeNorthSouth, sizeEastWest, min, max);
        FarmHelper.setExtents(this.world, this, targets);
    }

    @Override
    public int getStoredFertilizerScaled(int scale) {
        return this.manager.getFertilizerManager().getStoredFertilizerScaled(this.inventory, scale);
    }

    @Override
    public BlockPos getFarmCorner(FarmDirection direction) {
        return this.manager.getFarmCorner(direction);
    }

    @Override
    public boolean hasLiquid(FluidStack liquid) {
        FluidStack drained = this.manager.getResourceTank().drainInternal(liquid, IFluidHandler.FluidAction.SIMULATE);
        return liquid.isFluidStackIdentical(drained);
    }

    @Override
    public void removeLiquid(FluidStack liquid) {
        this.manager.getResourceTank().drain(liquid.getAmount(), IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public boolean plantGermling(IFarmable germling, World world, BlockPos pos, FarmDirection direction) {
        PlayerEntity player = PlayerUtil.getFakePlayer(world, this.getOwnerHandler().getOwner());
        return player != null && this.inventory.plantGermling(germling, player, pos);
    }

    @Override
    public IFarmInventoryInternal getFarmInventory() {
        return this.inventory;
    }

    @Override
    public void addPendingProduct(ItemStack stack) {
        this.manager.addPendingProduct(stack);
    }

    @Override
    public void setFarmLogic(FarmDirection direction, IFarmLogic logic) {
        Preconditions.checkNotNull((Object)((Object)direction));
        Preconditions.checkNotNull((Object)logic, (Object)"logic must not be null");
        this.farmLogics.put(direction, logic);
        this.cleanExtents(direction);
    }

    @Override
    public void resetFarmLogic(FarmDirection direction) {
        this.setFarmLogic(direction, FarmDefinition.ARBOREAL.getProperties().getLogic(false));
    }

    @Override
    public IFarmLogic getFarmLogic(FarmDirection direction) {
        return this.farmLogics.get((Object)direction);
    }

    @Override
    public Collection<IFarmLogic> getFarmLogics() {
        return this.farmLogics.values();
    }

    @Override
    public int getSocketCount() {
        return this.sockets.func_70302_i_();
    }

    @Override
    public ItemStack getSocket(int slot) {
        return this.sockets.func_70301_a(slot);
    }

    @Override
    public void setSocket(int slot, ItemStack stack) {
        if (ChipsetManager.circuitRegistry.isChipset(stack) || stack.func_190926_b()) {
            ICircuitBoard chipset;
            if (!this.sockets.func_70301_a(slot).func_190926_b() && ChipsetManager.circuitRegistry.isChipset(this.sockets.func_70301_a(slot)) && (chipset = ChipsetManager.circuitRegistry.getCircuitBoard(this.sockets.func_70301_a(slot))) != null) {
                chipset.onRemoval(this);
            }
            this.sockets.func_70299_a(slot, stack);
            this.refreshFarmLogics();
            if (!stack.func_190926_b() && (chipset = ChipsetManager.circuitRegistry.getCircuitBoard(stack)) != null) {
                chipset.onInsertion(this);
            }
        }
    }

    @Override
    public ICircuitSocketType getSocketType() {
        return CircuitSocketType.FARM;
    }

    @Override
    public boolean canPlantSoil(boolean manual) {
        return true;
    }

    @Override
    public boolean isValidPlatform(World world, BlockPos pos) {
        BlockState blockState = world.func_180495_p(pos);
        return FarmHelper.bricks.contains((Object)blockState.func_177230_c());
    }

    @Override
    public boolean isSquare() {
        return Config.squareFarms;
    }

    @Override
    public int getExtents(FarmDirection direction, BlockPos pos) {
        return this.manager.getExtents(direction, pos);
    }

    @Override
    public void setExtents(FarmDirection direction, BlockPos pos, int extend) {
        this.manager.setExtents(direction, pos, extend);
    }

    @Override
    public void cleanExtents(FarmDirection direction) {
        this.manager.cleanExtents(direction);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("logic", (Object)this.farmLogics.toString()).toString();
    }
}

