/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.multiblock;

import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.cultivation.IFarmHousingInternal;
import forestry.farming.multiblock.IFarmInventoryInternal;
import net.minecraft.nbt.CompoundNBT;

public class FarmFertilizerManager
implements INbtWritable,
INbtReadable,
IStreamable {
    private static final int BUFFER_FERTILIZER = 200;
    private final IFarmInventoryInternal inventory;
    private int storedFertilizer;

    public FarmFertilizerManager(IFarmHousingInternal housing) {
        this.inventory = housing.getFarmInventory();
        this.storedFertilizer = 0;
    }

    public boolean hasFertilizer(int amount) {
        if (this.inventory.getFertilizerValue() < 0) {
            return true;
        }
        return this.storedFertilizer >= amount;
    }

    public void removeFertilizer(int amount) {
        if (this.inventory.getFertilizerValue() < 0) {
            return;
        }
        this.storedFertilizer -= amount;
        if (this.storedFertilizer < 0) {
            this.storedFertilizer = 0;
        }
    }

    public boolean maintainFertilizer() {
        if (this.storedFertilizer <= 200) {
            int fertilizerValue = this.inventory.getFertilizerValue();
            if (fertilizerValue < 0) {
                this.storedFertilizer += 2000;
            } else if (this.inventory.useFertilizer()) {
                this.storedFertilizer += fertilizerValue;
            }
        }
        return this.storedFertilizer > 0;
    }

    @Override
    public void read(CompoundNBT data) {
        this.storedFertilizer = data.func_74762_e("StoredFertilizer");
    }

    @Override
    public CompoundNBT write(CompoundNBT data) {
        data.func_74768_a("StoredFertilizer", this.storedFertilizer);
        return data;
    }

    public int getStoredFertilizerScaled(IFarmInventoryInternal inventory, int scale) {
        if (this.storedFertilizer == 0) {
            return 0;
        }
        return this.storedFertilizer * scale / (inventory.getFertilizerValue() + 200);
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        data.func_150787_b(this.storedFertilizer);
    }

    @Override
    public void readData(PacketBufferForestry data) {
        this.storedFertilizer = data.func_150792_a();
    }
}

