/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.tiles;

import forestry.api.multiblock.IFarmComponent;
import forestry.energy.EnergyHelper;
import forestry.energy.EnergyManager;
import forestry.farming.features.FarmingTiles;
import forestry.farming.multiblock.IFarmControllerInternal;
import forestry.farming.multiblock.MultiblockLogicFarm;
import forestry.farming.tiles.TileFarm;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileFarmGearbox
extends TileFarm
implements IFarmComponent.Active {
    private static final int WORK_CYCLES = 4;
    private static final int ENERGY_PER_OPERATION = 200;
    private final EnergyManager energyManager = new EnergyManager(200, 10000);
    private int activationDelay = 0;
    private int previousDelays = 0;
    private int workCounter;

    public TileFarmGearbox() {
        super(FarmingTiles.GEARBOX.tileType());
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        super.func_230337_a_(state, compoundNBT);
        this.energyManager.read(compoundNBT);
        this.activationDelay = compoundNBT.func_74762_e("ActivationDelay");
        this.previousDelays = compoundNBT.func_74762_e("PrevDelays");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT = super.func_189515_b(compoundNBT);
        this.energyManager.write(compoundNBT);
        compoundNBT.func_74768_a("ActivationDelay", this.activationDelay);
        compoundNBT.func_74768_a("PrevDelays", this.previousDelays);
        return compoundNBT;
    }

    @Override
    public void updateServer(int tickCount) {
        if (this.energyManager.getEnergyStored() <= 0) {
            return;
        }
        if (this.activationDelay > 0) {
            --this.activationDelay;
            return;
        }
        if (this.workCounter < 4 && EnergyHelper.consumeEnergyToDoWork(this.energyManager, 4, 200)) {
            ++this.workCounter;
        }
        if (this.workCounter >= 4 && tickCount % 5 == 0) {
            IFarmControllerInternal farmController = ((MultiblockLogicFarm)this.getMultiblockLogic()).getController();
            if (farmController.doWork()) {
                this.workCounter = 0;
                this.previousDelays = 0;
            } else {
                this.activationDelay = Math.min(10 * this.previousDelays, 120);
                ++this.previousDelays;
            }
        }
    }

    @Override
    public void updateClient(int tickCount) {
    }

    public EnergyManager getEnergyManager() {
        return this.energyManager;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        LazyOptional<T> energyCapability = this.energyManager.getCapability(capability);
        if (energyCapability.isPresent()) {
            return energyCapability;
        }
        return super.getCapability(capability, facing);
    }
}

