/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.compat;

import forestry.lepidopterology.features.LepidopterologyItems;
import forestry.modules.ModuleHelper;
import genetics.api.GeneticHelper;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@JeiPlugin
public class LepidopterologyJeiPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("forestry");
    }

    public void registerItemSubtypes(ISubtypeRegistration subtypeRegistry) {
        if (!ModuleHelper.isEnabled("lepidopterology")) {
            return;
        }
        ISubtypeInterpreter butterflySubtypeInterpreter = itemStack -> {
            Optional individual = GeneticHelper.getIndividual(itemStack);
            return individual.map(iIndividual -> iIndividual.getGenome().getPrimary().getBinomial()).orElse("");
        };
        subtypeRegistry.registerSubtypeInterpreter(LepidopterologyItems.BUTTERFLY_GE.item(), butterflySubtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(LepidopterologyItems.COCOON_GE.item(), butterflySubtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(LepidopterologyItems.CATERPILLAR_GE.item(), butterflySubtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(LepidopterologyItems.SERUM_GE.item(), butterflySubtypeInterpreter);
    }
}

