/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import forestry.lepidopterology.entities.EntityButterfly;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;

public abstract class AIButterflyBase
extends Goal {
    protected final EntityButterfly entity;

    protected AIButterflyBase(EntityButterfly entity) {
        this.entity = entity;
    }

    @Nullable
    protected Vector3d getRandomDestination() {
        if (this.entity.func_70090_H()) {
            return this.getRandomDestinationUpwards();
        }
        Vector3d entityPos = this.entity.func_213303_ch();
        Vector3d randomTarget = RandomPositionGenerator.func_75461_b((CreatureEntity)this.entity, (int)16, (int)7, (Vector3d)entityPos);
        if (randomTarget != null && this.validateDestination(randomTarget, false)) {
            return randomTarget;
        }
        return null;
    }

    @Nullable
    protected Vector3d getRandomDestinationUpwards() {
        Vector3d entityPos = this.entity.func_213303_ch();
        Vector3d destination = entityPos.func_72441_c(0.0, (double)(this.entity.func_70681_au().nextInt(10) + 2), 0.0);
        if (this.validateDestination(destination, true)) {
            return destination;
        }
        return null;
    }

    private boolean validateDestination(Vector3d dest, boolean allowFluids) {
        if (dest.field_72448_b < 1.0) {
            return false;
        }
        BlockPos pos = new BlockPos(dest);
        if (!this.entity.field_70170_p.func_175667_e(pos)) {
            return false;
        }
        BlockState blockState = this.entity.field_70170_p.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (!allowFluids && blockState.func_185904_a().func_76224_d()) {
            return false;
        }
        if (!block.isAir(blockState, (IBlockReader)this.entity.field_70170_p, pos)) {
            return false;
        }
        return this.entity.getButterfly().isAcceptedEnvironment(this.entity.field_70170_p, dest.field_72450_a, dest.field_72448_b, dest.field_72449_c);
    }
}

