/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import forestry.api.lepidopterology.IButterflyNursery;
import forestry.api.lepidopterology.genetics.ButterflyChromosomes;
import forestry.core.utils.GeneticsUtil;
import forestry.lepidopterology.entities.AIButterflyInteract;
import forestry.lepidopterology.entities.EntityButterfly;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.world.IWorld;

public class AIButterflyMate
extends AIButterflyInteract {
    @Nullable
    private EntityButterfly targetMate;

    public AIButterflyMate(EntityButterfly entity) {
        super(entity);
    }

    @Override
    protected boolean canInteract() {
        if (!this.entity.getButterfly().getMate().isPresent() && this.entity.canMate()) {
            return true;
        }
        if (this.entity.cooldownEgg > 0) {
            return false;
        }
        if (!this.entity.getButterfly().getMate().isPresent()) {
            return false;
        }
        return this.rest != null && GeneticsUtil.canNurse(this.entity.getButterfly(), this.entity.field_70170_p, this.rest);
    }

    public void func_75246_d() {
        if (this.func_75253_b()) {
            if (!this.entity.getButterfly().getMate().isPresent() && this.targetMate != null) {
                if (this.entity.cooldownMate <= 0 && (double)this.entity.func_70032_d((Entity)this.targetMate) < 9.0) {
                    this.entity.getButterfly().mate(this.targetMate.getButterfly().getGenome());
                    this.targetMate.getButterfly().mate(this.entity.getButterfly().getGenome());
                    this.entity.cooldownMate = 1500;
                }
            } else if (this.rest != null) {
                IButterflyNursery nursery = GeneticsUtil.getOrCreateNursery(null, (IWorld)this.entity.field_70170_p, this.rest, false);
                if (nursery != null && nursery.canNurse(this.entity.getButterfly())) {
                    nursery.setCaterpillar(this.entity.getButterfly().spawnCaterpillar(this.entity.field_70170_p, nursery));
                    if (this.entity.func_70681_au().nextFloat() < 1.0f / (float)this.entity.getButterfly().getGenome().getActiveValue(ButterflyChromosomes.FERTILITY).intValue()) {
                        this.entity.func_70606_j(0.0f);
                    }
                }
                this.setHasInteracted();
                this.entity.cooldownEgg = 1500;
            }
        }
    }

    @Override
    public boolean func_75250_a() {
        if (!super.func_75250_a()) {
            return false;
        }
        if (!this.entity.getButterfly().getMate().isPresent()) {
            if (!this.entity.canMate()) {
                return false;
            }
            this.targetMate = this.getNearbyMate();
            return this.targetMate != null;
        }
        return true;
    }

    @Override
    public boolean func_75253_b() {
        if (!super.func_75253_b()) {
            return false;
        }
        if (!this.entity.getButterfly().getMate().isPresent()) {
            return this.targetMate != null && this.targetMate.func_70089_S() && this.targetMate.canMate();
        }
        return true;
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.targetMate = null;
    }

    @Nullable
    private EntityButterfly getNearbyMate() {
        float f = 8.0f;
        List nextButterflys = this.entity.field_70170_p.func_217357_a(EntityButterfly.class, this.entity.func_174813_aQ().func_72321_a((double)f, (double)f, (double)f));
        double d0 = Double.MAX_VALUE;
        EntityButterfly nextButterfly = null;
        for (EntityButterfly butterfly : nextButterflys) {
            if (!this.entity.canMateWith(butterfly) || !((double)this.entity.func_70032_d((Entity)butterfly) < d0)) continue;
            nextButterfly = butterfly;
            d0 = this.entity.func_70032_d((Entity)butterfly);
        }
        return nextButterfly;
    }
}

