/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.EnumGermlingType;
import forestry.api.arboriculture.genetics.ITreeRoot;
import forestry.api.core.IToolScoop;
import forestry.api.lepidopterology.IEntityButterfly;
import forestry.api.lepidopterology.ILepidopteristTracker;
import forestry.api.lepidopterology.genetics.ButterflyChromosomes;
import forestry.api.lepidopterology.genetics.EnumFlutterType;
import forestry.api.lepidopterology.genetics.IAlleleButterflySpecies;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.api.lepidopterology.genetics.IButterflyRoot;
import forestry.core.utils.ItemStackUtil;
import forestry.lepidopterology.ModuleLepidopterology;
import forestry.lepidopterology.entities.AIButterflyFlee;
import forestry.lepidopterology.entities.AIButterflyMate;
import forestry.lepidopterology.entities.AIButterflyPollinate;
import forestry.lepidopterology.entities.AIButterflyRest;
import forestry.lepidopterology.entities.AIButterflyRise;
import forestry.lepidopterology.entities.AIButterflyWander;
import forestry.lepidopterology.entities.EnumButterflyState;
import forestry.lepidopterology.genetics.Butterfly;
import forestry.lepidopterology.genetics.ButterflyHelper;
import genetics.api.GeneticsAPI;
import genetics.api.alleles.IAllele;
import genetics.api.individual.IGenome;
import genetics.api.individual.IIndividual;
import genetics.api.organism.IOrganismType;
import genetics.api.root.EmptyRootDefinition;
import genetics.api.root.IIndividualRoot;
import genetics.api.root.IRootDefinition;
import genetics.utils.AlleleUtils;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.WallBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;

public class EntityButterfly
extends CreatureEntity
implements IEntityButterfly {
    private static final String NBT_BUTTERFLY = "BTFLY";
    private static final String NBT_ROOT = "ROT";
    private static final String NBT_POLLEN = "PLN";
    private static final String NBT_STATE = "STATE";
    private static final String NBT_EXHAUSTION = "EXH";
    private static final String NBT_HOME = "HOME";
    public static final int COOLDOWNS = 1500;
    private static final DataParameter<String> DATAWATCHER_ID_SPECIES = EntityDataManager.func_187226_a(EntityButterfly.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> DATAWATCHER_ID_SIZE = EntityDataManager.func_187226_a(EntityButterfly.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> DATAWATCHER_ID_STATE = EntityDataManager.func_187226_a(EntityButterfly.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final float DEFAULT_BUTTERFLY_SIZE = 0.75f;
    private static final EnumButterflyState DEFAULT_STATE = EnumButterflyState.FLYING;
    public static final int EXHAUSTION_REST = 1000;
    public static final int EXHAUSTION_CONSUMPTION = 100000;
    public static final int MAX_LIFESPAN = 168000;
    @Nullable
    private Vector3d flightTarget;
    private int exhaustion;
    private IButterfly contained = ButterflyHelper.getKaryotype().getDefaultTemplate().toIndividual(ButterflyHelper.getRoot());
    @Nullable
    private IIndividual pollen;
    public int cooldownPollination = 0;
    public int cooldownEgg = 0;
    public int cooldownMate = 0;
    @Nullable
    private IAlleleButterflySpecies species;
    private float size = 0.75f;
    private EnumButterflyState state = DEFAULT_STATE;
    @OnlyIn(value=Dist.CLIENT)
    private ResourceLocation textureResource;

    public EntityButterfly(EntityType<EntityButterfly> type, World world) {
        super(type, world);
        this.setDefaults();
    }

    public static EntityButterfly create(EntityType<EntityButterfly> type, World world, IButterfly butterfly, BlockPos homePos) {
        EntityButterfly bf = new EntityButterfly(type, world);
        bf.setDefaults();
        bf.setIndividual(butterfly);
        bf.func_213390_a(homePos, ModuleLepidopterology.maxDistance);
        return bf;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATAWATCHER_ID_SPECIES, (Object)"");
        this.field_70180_af.func_187214_a(DATAWATCHER_ID_SIZE, (Object)75);
        this.field_70180_af.func_187214_a(DATAWATCHER_ID_STATE, (Object)((byte)DEFAULT_STATE.ordinal()));
    }

    private void setDefaults() {
        this.field_70714_bg.func_75776_a(8, (Goal)new AIButterflyFlee(this));
        this.field_70714_bg.func_75776_a(9, (Goal)new AIButterflyMate(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new AIButterflyPollinate(this));
        this.field_70714_bg.func_75776_a(11, (Goal)new AIButterflyRest(this));
        this.field_70714_bg.func_75776_a(12, (Goal)new AIButterflyRise(this));
        this.field_70714_bg.func_75776_a(12, (Goal)new AIButterflyWander(this));
    }

    @Override
    public CreatureEntity getEntity() {
        return this;
    }

    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        CompoundNBT bio = new CompoundNBT();
        this.contained.write(bio);
        compoundNBT.func_218657_a(NBT_BUTTERFLY, (INBT)bio);
        if (this.pollen != null) {
            CompoundNBT pln = new CompoundNBT();
            pln.func_74778_a(NBT_ROOT, this.pollen.getRoot().getUID());
            this.pollen.write(pln);
            compoundNBT.func_218657_a(NBT_POLLEN, (INBT)pln);
        }
        compoundNBT.func_74774_a(NBT_STATE, (byte)this.getState().ordinal());
        compoundNBT.func_74768_a(NBT_EXHAUSTION, this.exhaustion);
        compoundNBT.func_74772_a(NBT_HOME, this.func_213384_dI().func_218275_a());
    }

    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        Butterfly butterfly = null;
        if (compoundNBT.func_74764_b(NBT_BUTTERFLY)) {
            butterfly = new Butterfly(compoundNBT.func_74775_l(NBT_BUTTERFLY));
        }
        this.setIndividual(butterfly);
        if (compoundNBT.func_74764_b(NBT_POLLEN)) {
            CompoundNBT pollenNBT = compoundNBT.func_74775_l(NBT_POLLEN);
            IRootDefinition<ITreeRoot> definition = EmptyRootDefinition.empty();
            if (pollenNBT.func_74764_b(NBT_ROOT)) {
                definition = GeneticsAPI.apiInstance.getRoot(pollenNBT.func_74779_i(NBT_ROOT));
            }
            this.pollen = definition.orElse(TreeManager.treeRoot).create(pollenNBT);
        }
        EnumButterflyState butterflyState = EnumButterflyState.VALUES[compoundNBT.func_74771_c(NBT_STATE)];
        this.setState(butterflyState);
        this.exhaustion = compoundNBT.func_74762_e(NBT_EXHAUSTION);
        BlockPos home = BlockPos.func_218283_e((long)compoundNBT.func_74763_f(NBT_HOME));
        this.func_213390_a(home, ModuleLepidopterology.maxDistance);
    }

    public float getWingFlap(float partialTickTime) {
        int offset = this.species != null ? this.species.getRegistryName().toString().hashCode() : this.field_70170_p.field_73012_v.nextInt();
        return this.getState().getWingFlap(this, offset, partialTickTime);
    }

    public void setState(EnumButterflyState state) {
        if (this.state != state) {
            this.state = state;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_187227_b(DATAWATCHER_ID_STATE, (Object)((byte)state.ordinal()));
            }
        }
    }

    public EnumButterflyState getState() {
        return this.state;
    }

    public float getSize() {
        return this.size;
    }

    public float func_70689_ay() {
        return this.contained.getGenome().getActiveValue(ButterflyChromosomes.SPEED).floatValue();
    }

    @Nullable
    public Vector3d getDestination() {
        return this.flightTarget;
    }

    public void setDestination(@Nullable Vector3d destination) {
        this.flightTarget = destination;
    }

    public float func_180484_a(BlockPos pos) {
        int depth;
        if (!this.field_70170_p.func_175667_e(pos)) {
            return -100.0f;
        }
        float weight = 0.0f;
        double distanceToHome = this.func_213384_dI().func_177951_i((Vector3i)pos);
        if (!this.isWithinHomeDistanceFromPosition(distanceToHome)) {
            weight = (float)((double)weight - (7.5 + 0.005 * (distanceToHome / 4.0)));
        }
        if (!this.getButterfly().isAcceptedEnvironment(this.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
            weight -= 15.0f;
        }
        if (!this.field_70170_p.func_217357_a(EntityButterfly.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1))).isEmpty()) {
            weight -= 1.0f;
        }
        if ((depth = this.getFluidDepth(pos)) > 0) {
            weight -= 0.1f * (float)depth;
        } else {
            BlockState blockState = this.field_70170_p.func_180495_p(pos);
            Block block = blockState.func_177230_c();
            if (block instanceof FlowerBlock) {
                weight += 2.0f;
            } else if (block instanceof IPlantable) {
                weight += 1.5f;
            } else if (block instanceof IGrowable) {
                weight += 1.0f;
            } else if (blockState.func_185904_a() == Material.field_151585_k) {
                weight += 1.0f;
            }
            BlockPos posBelow = pos.func_177977_b();
            BlockState blockStateBelow = this.field_70170_p.func_180495_p(posBelow);
            Block blockBelow = blockStateBelow.func_177230_c();
            if (blockBelow.func_203417_a((ITag)BlockTags.field_206952_E)) {
                weight += 2.5f;
            } else if (blockBelow instanceof FenceBlock) {
                weight += 1.0f;
            } else if (blockBelow instanceof WallBlock) {
                weight += 1.0f;
            }
        }
        return weight += this.field_70170_p.func_205052_D(pos);
    }

    private boolean isWithinHomeDistanceFromPosition(double distanceToHome) {
        return distanceToHome < (double)(this.func_213391_dJ() * this.func_213391_dJ());
    }

    private int getFluidDepth(BlockPos pos) {
        IChunk chunk = this.field_70170_p.func_217349_x(pos);
        int xx = pos.func_177958_n() & 0xF;
        int zz = pos.func_177952_p() & 0xF;
        int depth = 0;
        for (int y = chunk.func_76625_h() + 15; y > 0; --y) {
            BlockState blockState = chunk.func_180495_p(new BlockPos(xx, y, zz));
            Block block = blockState.func_177230_c();
            if (blockState.func_185904_a().func_76224_d()) {
                ++depth;
                continue;
            }
            if (!block.isAir(blockState, (IBlockReader)this.field_70170_p, pos)) break;
        }
        return depth;
    }

    @Override
    @Nullable
    public IIndividual getPollen() {
        return this.pollen;
    }

    @Override
    public void setPollen(@Nullable IIndividual pollen) {
        this.pollen = pollen;
    }

    @Override
    public void changeExhaustion(int change) {
        this.exhaustion = Math.max(this.exhaustion + change, 0);
    }

    @Override
    public int getExhaustion() {
        return this.exhaustion;
    }

    public boolean canFly() {
        return this.contained.canTakeFlight(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
    }

    public void setIndividual(@Nullable IButterfly butterfly) {
        if (butterfly == null) {
            butterfly = ButterflyHelper.getKaryotype().getDefaultTemplate().toIndividual(ButterflyHelper.getRoot());
        }
        this.contained = butterfly;
        IGenome genome = this.contained.getGenome();
        this.size = genome.getActiveValue(ButterflyChromosomes.SIZE).floatValue();
        this.species = genome.getActiveAllele(ButterflyChromosomes.SPECIES);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(DATAWATCHER_ID_SIZE, (Object)((int)(this.size * 100.0f)));
            this.field_70180_af.func_187227_b(DATAWATCHER_ID_SPECIES, (Object)this.species.getRegistryName().toString());
        } else {
            this.textureResource = this.species.getEntityTexture();
        }
    }

    @Override
    public IButterfly getButterfly() {
        return this.contained;
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (!this.field_70170_p.field_72995_K) {
            this.setIndividual(this.contained);
        }
        return spawnDataIn;
    }

    public ITextComponent func_200200_C_() {
        if (this.species == null) {
            return super.func_200200_C_();
        }
        return this.species.getDisplayName();
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return true;
    }

    public int func_82145_z() {
        return 1000;
    }

    public boolean isRenderable() {
        return this.species != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTexture() {
        return this.textureResource;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity other) {
    }

    public boolean func_175446_cd() {
        return false;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return this.field_70173_aa > 168000;
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (this.field_70729_aU) {
            return ActionResultType.FAIL;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof IToolScoop) {
            if (!this.field_70170_p.field_72995_K) {
                IButterflyRoot root = ButterflyHelper.getRoot();
                ILepidopteristTracker tracker = root.getBreedingTracker((IWorld)this.field_70170_p, player.func_146103_bH());
                ItemStack itemStack = root.getTypes().createStack(this.contained.copy(), EnumFlutterType.BUTTERFLY);
                tracker.registerCatch(this.contained);
                ItemStackUtil.dropItemStackAsEntity(itemStack, this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                this.field_70729_aU = true;
            } else {
                player.func_184609_a(hand);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        for (ItemStack stack : this.contained.getLootDrop(this, recentlyHitIn, looting)) {
            ItemStackUtil.dropItemStackAsEntity(stack, this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
        IIndividual pollen = this.getPollen();
        if (pollen != null) {
            IRootDefinition<IIndividualRoot> definition = GeneticsAPI.apiInstance.getRootHelper().getSpeciesRoot(pollen);
            if (!definition.isPresent()) {
                return;
            }
            definition.ifPresent(root -> {
                ItemStack pollenStack = root.createStack(pollen, (IOrganismType)EnumGermlingType.POLLEN);
                ItemStackUtil.dropItemStackAsEntity(pollenStack, this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            });
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            IAllele allele;
            String speciesUid;
            Optional optionalAllele;
            if (this.species == null && (optionalAllele = AlleleUtils.getAllele(speciesUid = (String)this.field_70180_af.func_187225_a(DATAWATCHER_ID_SPECIES))).isPresent() && (allele = (IAllele)optionalAllele.get()) instanceof IAlleleButterflySpecies) {
                this.species = (IAlleleButterflySpecies)allele;
                this.textureResource = this.species.getEntityTexture();
                this.size = (float)((Integer)this.field_70180_af.func_187225_a(DATAWATCHER_ID_SIZE)).intValue() / 100.0f;
            }
            byte stateOrdinal = (Byte)this.field_70180_af.func_187225_a(DATAWATCHER_ID_STATE);
            if (this.state.ordinal() != stateOrdinal) {
                this.setState(EnumButterflyState.VALUES[stateOrdinal]);
            }
        }
        Vector3d motion = this.func_213322_ci();
        this.func_213293_j(motion.field_72450_a, motion.field_72448_b * (double)0.6f, motion.field_72449_c);
        if (this.exhaustion > 100000 && this.func_70681_au().nextInt(20) == 0) {
            this.func_70097_a(DamageSource.field_76377_j, 1.0f);
        }
        if (this.field_70173_aa > 168000) {
            this.func_70097_a(DamageSource.field_76377_j, 1.0f);
        }
        if (this.cooldownEgg > 0) {
            --this.cooldownEgg;
        }
        if (this.cooldownPollination > 0) {
            --this.cooldownPollination;
        }
        if (this.cooldownMate > 0) {
            --this.cooldownMate;
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.getState().doesMovement && this.flightTarget != null) {
            double diffX = this.flightTarget.field_72450_a + 0.5 - this.func_226277_ct_();
            double diffY = this.flightTarget.field_72448_b + 0.1 - this.func_226278_cu_();
            double diffZ = this.flightTarget.field_72449_c + 0.5 - this.func_226281_cx_();
            Vector3d motion = this.func_213322_ci();
            double newX = (Math.signum(diffX) * 0.5 - motion.field_72450_a) * (double)0.1f;
            double newY = (Math.signum(diffY) * (double)0.7f - motion.field_72448_b) * (double)0.1f;
            double newZ = (Math.signum(diffZ) * 0.5 - motion.field_72449_c) * (double)0.1f;
            this.func_213293_j(newX, newY, newZ);
            float horizontal = (float)(Math.atan2(newZ, newX) * 180.0 / Math.PI) - 90.0f;
            this.field_70177_z += MathHelper.func_76142_g((float)(horizontal - this.field_70177_z));
            this.func_191989_p(this.contained.getGenome().getActiveValue(ButterflyChromosomes.SPEED).floatValue());
        }
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean func_145773_az() {
        return true;
    }

    protected float func_70599_aP() {
        return 0.1f;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        if (this.species == null) {
            return ItemStack.field_190927_a;
        }
        IButterflyRoot root = this.species.getRoot();
        IAllele[] template = root.getTemplates().getTemplate(this.species.getRegistryName().toString());
        IButterfly butterfly = (IButterfly)root.templateAsIndividual(template);
        return root.getTypes().createStack(butterfly, EnumFlutterType.BUTTERFLY);
    }

    @Override
    public boolean canMateWith(IEntityButterfly butterfly) {
        if (butterfly.getButterfly().getMate().isPresent()) {
            return false;
        }
        if (this.getButterfly().getMate().isPresent()) {
            return false;
        }
        return !this.getButterfly().isGeneticEqual(butterfly.getButterfly());
    }

    @Override
    public boolean canMate() {
        return this.cooldownMate <= 0;
    }
}

