/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IErrorState;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.alleles.AlleleManager;
import forestry.api.genetics.products.IDynamicProductList;
import forestry.api.genetics.products.Product;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.IButterflyCocoon;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.api.lepidopterology.IEntityButterfly;
import forestry.api.lepidopterology.genetics.ButterflyChromosomes;
import forestry.api.lepidopterology.genetics.EnumFlutterType;
import forestry.api.lepidopterology.genetics.IAlleleButterflySpecies;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.api.lepidopterology.genetics.IButterflyMutation;
import forestry.core.errors.EnumErrorCode;
import forestry.core.genetics.IndividualLiving;
import forestry.core.utils.ClimateUtil;
import forestry.lepidopterology.ModuleLepidopterology;
import forestry.lepidopterology.genetics.ButterflyHelper;
import genetics.api.alleles.IAllele;
import genetics.api.individual.IChromosome;
import genetics.api.individual.IGenome;
import genetics.api.mutation.IMutationContainer;
import genetics.api.root.IIndividualRoot;
import genetics.api.root.components.ComponentKeys;
import genetics.individual.Genome;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class Butterfly
extends IndividualLiving
implements IButterfly {
    private static final Random rand = new Random();

    public Butterfly(CompoundNBT nbt) {
        super(nbt);
    }

    public Butterfly(IGenome genome) {
        super(genome, null, genome.getActiveValue(ButterflyChromosomes.LIFESPAN));
    }

    public Butterfly(IGenome genome, @Nullable IGenome mate) {
        super(genome, mate);
    }

    @Override
    public IIndividualRoot getRoot() {
        return ButterflyHelper.getRoot();
    }

    @Override
    public void addTooltip(List<ITextComponent> list) {
    }

    @Override
    public IButterfly copy() {
        CompoundNBT compoundNBT = new CompoundNBT();
        this.write(compoundNBT);
        return new Butterfly(compoundNBT);
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.genome.getPrimary().getDisplayName();
    }

    @Override
    public Set<IErrorState> getCanSpawn(IButterflyNursery nursery, @Nullable IButterflyCocoon cocoon) {
        World world = nursery.getWorldObj();
        HashSet<IErrorState> errorStates = new HashSet<IErrorState>();
        boolean isDaytime = world.func_72935_r();
        if (!this.isActiveThisTime(isDaytime)) {
            if (isDaytime) {
                errorStates.add(EnumErrorCode.NOT_NIGHT);
            } else {
                errorStates.add(EnumErrorCode.NOT_DAY);
            }
        }
        IAlleleButterflySpecies species = this.genome.getActiveAllele(ButterflyChromosomes.SPECIES);
        EnumTemperature actualTemperature = nursery.getTemperature();
        EnumTemperature baseTemperature = species.getTemperature();
        EnumTolerance toleranceTemperature = this.genome.getActiveValue(ButterflyChromosomes.TEMPERATURE_TOLERANCE);
        EnumHumidity actualHumidity = nursery.getHumidity();
        EnumHumidity baseHumidity = species.getHumidity();
        EnumTolerance toleranceHumidity = this.genome.getActiveValue(ButterflyChromosomes.HUMIDITY_TOLERANCE);
        ClimateUtil.addClimateErrorStates(actualTemperature, actualHumidity, baseTemperature, toleranceTemperature, baseHumidity, toleranceHumidity, errorStates);
        return errorStates;
    }

    @Override
    public Set<IErrorState> getCanGrow(IButterflyNursery nursery, @Nullable IButterflyCocoon cocoon) {
        HashSet<IErrorState> errorStates = new HashSet<IErrorState>();
        IAlleleButterflySpecies species = this.genome.getActiveAllele(ButterflyChromosomes.SPECIES);
        EnumTemperature actualTemperature = nursery.getTemperature();
        EnumTemperature baseTemperature = species.getTemperature();
        EnumTolerance toleranceTemperature = this.genome.getActiveValue(ButterflyChromosomes.TEMPERATURE_TOLERANCE);
        EnumHumidity actualHumidity = nursery.getHumidity();
        EnumHumidity baseHumidity = species.getHumidity();
        EnumTolerance toleranceHumidity = this.genome.getActiveValue(ButterflyChromosomes.HUMIDITY_TOLERANCE);
        ClimateUtil.addClimateErrorStates(actualTemperature, actualHumidity, baseTemperature, toleranceTemperature, baseHumidity, toleranceHumidity, errorStates);
        return errorStates;
    }

    @Override
    public boolean canSpawn(World world, double x, double y, double z) {
        block3: {
            boolean noneMatched;
            block5: {
                IAlleleButterflySpecies species;
                Biome biome;
                block4: {
                    if (!this.canFly(world)) {
                        return false;
                    }
                    biome = world.func_226691_t_(new BlockPos(x, 0.0, z));
                    species = this.getGenome().getActiveAllele(ButterflyChromosomes.SPECIES);
                    if (species.getSpawnBiomes().isEmpty()) break block3;
                    noneMatched = true;
                    if (!species.strictSpawnMatch()) break block4;
                    Biome.Category category = biome.func_201856_r();
                    if (!species.getSpawnBiomes().contains(category)) break block5;
                    noneMatched = false;
                    break block5;
                }
                for (Biome.Category type : species.getSpawnBiomes()) {
                    if (type != biome.func_201856_r()) continue;
                    noneMatched = false;
                    break;
                }
            }
            if (noneMatched) {
                return false;
            }
        }
        return this.isAcceptedEnvironment(world, x, y, z);
    }

    @Override
    public boolean canTakeFlight(World world, double x, double y, double z) {
        return this.canFly(world) && this.isAcceptedEnvironment(world, x, y, z);
    }

    private boolean canFly(World world) {
        return (!world.func_72896_J() || this.getGenome().getActiveValue(ButterflyChromosomes.TOLERANT_FLYER) != false) && this.isActiveThisTime(world.func_72935_r());
    }

    @Override
    public boolean isAcceptedEnvironment(World world, double x, double y, double z) {
        return this.isAcceptedEnvironment(world, (int)x, (int)y, (int)z);
    }

    private boolean isAcceptedEnvironment(World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        Biome biome = world.func_226691_t_(pos);
        EnumTemperature biomeTemperature = EnumTemperature.getFromBiome(biome, pos);
        EnumHumidity biomeHumidity = EnumHumidity.getFromValue(biome.func_76727_i());
        return AlleleManager.climateHelper.isWithinLimits(biomeTemperature, biomeHumidity, this.getGenome().getActiveAllele(ButterflyChromosomes.SPECIES).getTemperature(), this.getGenome().getActiveValue(ButterflyChromosomes.TEMPERATURE_TOLERANCE), this.getGenome().getActiveAllele(ButterflyChromosomes.SPECIES).getHumidity(), this.getGenome().getActiveValue(ButterflyChromosomes.HUMIDITY_TOLERANCE));
    }

    @Override
    @Nullable
    public IButterfly spawnCaterpillar(World world, IButterflyNursery nursery) {
        IChromosome[] mutated2;
        if (this.mate == null) {
            return null;
        }
        IChromosome[] chromosomes = new IChromosome[this.genome.getChromosomes().length];
        IChromosome[] parent1 = this.genome.getChromosomes();
        IChromosome[] parent2 = this.mate.getChromosomes();
        IChromosome[] mutated1 = Butterfly.mutateSpecies(world, nursery, this.genome, this.mate);
        if (mutated1 != null) {
            parent1 = mutated1;
        }
        if ((mutated2 = Butterfly.mutateSpecies(world, nursery, this.mate, this.genome)) != null) {
            parent2 = mutated2;
        }
        for (int i = 0; i < parent1.length; ++i) {
            if (parent1[i] == null || parent2[i] == null) continue;
            chromosomes[i] = parent1[i].inheritChromosome(rand, parent2[i]);
        }
        return new Butterfly(new Genome(ButterflyHelper.getRoot().getKaryotype(), chromosomes));
    }

    @Nullable
    private static IChromosome[] mutateSpecies(World world, IButterflyNursery nursery, IGenome genomeOne, IGenome genomeTwo) {
        IGenome genome1;
        IGenome genome0;
        IAllele allele1;
        IAllele allele0;
        IChromosome[] parent1 = genomeOne.getChromosomes();
        IChromosome[] parent2 = genomeTwo.getChromosomes();
        if (rand.nextBoolean()) {
            allele0 = parent1[ButterflyChromosomes.SPECIES.ordinal()].getActiveAllele();
            allele1 = parent2[ButterflyChromosomes.SPECIES.ordinal()].getInactiveAllele();
            genome0 = genomeOne;
            genome1 = genomeTwo;
        } else {
            allele0 = parent2[ButterflyChromosomes.SPECIES.ordinal()].getActiveAllele();
            allele1 = parent1[ButterflyChromosomes.SPECIES.ordinal()].getInactiveAllele();
            genome0 = genomeTwo;
            genome1 = genomeOne;
        }
        IMutationContainer container = (IMutationContainer)ButterflyHelper.getRoot().getComponent(ComponentKeys.MUTATIONS);
        for (IButterflyMutation mutation : container.getMutations(true)) {
            float chance = mutation.getChance(world, nursery, allele0, allele1, genome0, genome1);
            if (!(chance > rand.nextFloat() * 100.0f)) continue;
            return ButterflyManager.butterflyRoot.getKaryotype().templateAsChromosomes(mutation.getTemplate());
        }
        return null;
    }

    private boolean isActiveThisTime(boolean isDayTime) {
        if (this.getGenome().getActiveValue(ButterflyChromosomes.NOCTURNAL).booleanValue()) {
            return true;
        }
        return isDayTime != this.getGenome().getActiveAllele(ButterflyChromosomes.SPECIES).isNocturnal();
    }

    @Override
    public float getSize() {
        return this.getGenome().getActiveValue(ButterflyChromosomes.SIZE).floatValue();
    }

    @Override
    public NonNullList<ItemStack> getLootDrop(IEntityButterfly entity, boolean playerKill, int lootLevel) {
        NonNullList drop = NonNullList.func_191196_a();
        CreatureEntity creature = entity.getEntity();
        float metabolism = (float)this.getGenome().getActiveValue(ButterflyChromosomes.METABOLISM).intValue() / 10.0f;
        IDynamicProductList products = this.getGenome().getActiveAllele(ButterflyChromosomes.SPECIES).getButterflyLoot();
        for (Product product : products.getPossibleProducts()) {
            if (!(creature.field_70170_p.field_73012_v.nextFloat() < product.getChance() * metabolism)) continue;
            drop.add((Object)product.copyStack());
        }
        return drop;
    }

    @Override
    public NonNullList<ItemStack> getCaterpillarDrop(IButterflyNursery nursery, boolean playerKill, int lootLevel) {
        NonNullList drop = NonNullList.func_191196_a();
        float metabolism = (float)this.getGenome().getActiveValue(ButterflyChromosomes.METABOLISM).intValue() / 10.0f;
        IDynamicProductList products = this.getGenome().getActiveAllele(ButterflyChromosomes.SPECIES).getCaterpillarLoot();
        for (Product product : products.getPossibleProducts()) {
            if (!(rand.nextFloat() < product.getChance() * metabolism)) continue;
            drop.add((Object)product.copyStack());
        }
        return drop;
    }

    @Override
    public NonNullList<ItemStack> getCocoonDrop(IButterflyCocoon cocoon) {
        NonNullList drop = NonNullList.func_191196_a();
        float metabolism = (float)this.getGenome().getActiveValue(ButterflyChromosomes.METABOLISM).intValue() / 10.0f;
        IDynamicProductList products = this.getGenome().getActiveAllele(ButterflyChromosomes.COCOON).getCocoonLoot();
        for (Product product : products.getPossibleProducts()) {
            if (!(rand.nextFloat() < product.getChance() * metabolism)) continue;
            drop.add((Object)product.copyStack());
        }
        if (ModuleLepidopterology.getSerumChance() > 0.0f && rand.nextFloat() < ModuleLepidopterology.getSerumChance() * metabolism) {
            ItemStack stack = ButterflyManager.butterflyRoot.getTypes().createStack(this, EnumFlutterType.SERUM);
            if (ModuleLepidopterology.getSecondSerumChance() > 0.0f && rand.nextFloat() < ModuleLepidopterology.getSecondSerumChance() * metabolism) {
                stack.func_190920_e(2);
            }
            drop.add((Object)ButterflyManager.butterflyRoot.getTypes().createStack(this, EnumFlutterType.SERUM));
        }
        if (cocoon.isSolid()) {
            drop.add((Object)ButterflyManager.butterflyRoot.getTypes().createStack(this, EnumFlutterType.BUTTERFLY));
        }
        return drop;
    }
}

