/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import forestry.api.genetics.alleles.AlleleManager;
import forestry.api.genetics.gatgets.DatabaseMode;
import forestry.api.genetics.gatgets.IDatabaseTab;
import forestry.api.lepidopterology.genetics.ButterflyChromosomes;
import forestry.api.lepidopterology.genetics.EnumFlutterType;
import forestry.api.lepidopterology.genetics.IAlleleButterflySpecies;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.core.genetics.GenericRatings;
import forestry.core.gui.elements.Alignment;
import forestry.core.gui.elements.DatabaseElement;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Translator;
import forestry.lepidopterology.genetics.ButterflyDefinition;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ButterflyDatabaseTab
implements IDatabaseTab<IButterfly> {
    private final DatabaseMode mode;

    ButterflyDatabaseTab(DatabaseMode mode) {
        this.mode = mode;
    }

    @Override
    public DatabaseMode getMode() {
        return this.mode;
    }

    @Override
    public void createElements(DatabaseElement database, IButterfly butterfly, ItemStack itemStack) {
        String nocturnalSecond;
        String diurnalSecond;
        String nocturnalFirst;
        String diurnalFirst;
        IAlleleButterflySpecies primarySpecies = butterfly.getGenome().getActiveAllele(ButterflyChromosomes.SPECIES);
        IAlleleButterflySpecies secondarySpecies = butterfly.getGenome().getInactiveAllele(ButterflyChromosomes.SPECIES);
        database.label(Translator.translateToLocal("for.gui.database.tab." + (this.mode == DatabaseMode.ACTIVE ? "active" : "inactive") + "_species.name"), Alignment.TOP_CENTER, GuiElementFactory.INSTANCE.databaseTitle);
        database.addLine(Translator.translateToLocal("for.gui.species"), ButterflyChromosomes.SPECIES);
        database.addLine(Translator.translateToLocal("for.gui.size"), ButterflyChromosomes.SIZE);
        database.addLine(Translator.translateToLocal("for.gui.lifespan"), ButterflyChromosomes.LIFESPAN);
        database.addLine(Translator.translateToLocal("for.gui.speed"), ButterflyChromosomes.SPEED);
        database.addLine(Translator.translateToLocal("for.gui.metabolism"), (allele, a) -> GenericRatings.rateMetabolism((Integer)allele.getValue()), ButterflyChromosomes.METABOLISM);
        database.addFertilityLine(Translator.translateToLocal("for.gui.fertility"), ButterflyChromosomes.FERTILITY, 8);
        database.addLine(Translator.translateToLocal("for.gui.flowers"), ButterflyChromosomes.FLOWER_PROVIDER);
        database.addLine(Translator.translateToLocal("for.gui.effect"), ButterflyChromosomes.EFFECT);
        Function<Boolean, String> toleranceText = a -> {
            IAlleleButterflySpecies species = a != false ? primarySpecies : secondarySpecies;
            return AlleleManager.climateHelper.toDisplay(species.getTemperature()).func_150261_e();
        };
        database.addLine(Translator.translateToLocal("for.gui.climate"), toleranceText, ButterflyChromosomes.TEMPERATURE_TOLERANCE);
        database.addToleranceLine(ButterflyChromosomes.TEMPERATURE_TOLERANCE);
        database.addLine(Translator.translateToLocal("for.gui.humidity"), toleranceText, ButterflyChromosomes.HUMIDITY_TOLERANCE);
        database.addToleranceLine(ButterflyChromosomes.HUMIDITY_TOLERANCE);
        String yes = Translator.translateToLocal("for.yes");
        String no = Translator.translateToLocal("for.no");
        if (butterfly.getGenome().getActiveValue(ButterflyChromosomes.NOCTURNAL).booleanValue()) {
            nocturnalFirst = diurnalFirst = yes;
        } else {
            nocturnalFirst = primarySpecies.isNocturnal() ? yes : no;
            String string = diurnalFirst = !primarySpecies.isNocturnal() ? yes : no;
        }
        if (butterfly.getGenome().getInactiveValue(ButterflyChromosomes.NOCTURNAL).booleanValue()) {
            nocturnalSecond = diurnalSecond = yes;
        } else {
            nocturnalSecond = secondarySpecies.isNocturnal() ? yes : no;
            diurnalSecond = !secondarySpecies.isNocturnal() ? yes : no;
        }
        database.addLine(Translator.translateToLocal("for.gui.diurnal"), a -> a != false ? diurnalFirst : diurnalSecond, false);
        database.addLine(Translator.translateToLocal("for.gui.nocturnal"), a -> a != false ? nocturnalFirst : nocturnalSecond, false);
        Function<Boolean, String> flyer = active -> StringUtil.readableBoolean(active != false ? butterfly.getGenome().getActiveValue(ButterflyChromosomes.TOLERANT_FLYER).booleanValue() : butterfly.getGenome().getInactiveValue(ButterflyChromosomes.TOLERANT_FLYER).booleanValue(), yes, no);
        database.addLine(Translator.translateToLocal("for.gui.flyer"), flyer, ButterflyChromosomes.TOLERANT_FLYER);
        Function<Boolean, String> fireresist = active -> StringUtil.readableBoolean(active != false ? butterfly.getGenome().getActiveValue(ButterflyChromosomes.FIRE_RESIST).booleanValue() : butterfly.getGenome().getInactiveValue(ButterflyChromosomes.FIRE_RESIST).booleanValue(), yes, no);
        database.addLine(Translator.translateToLocal("for.gui.fireresist"), fireresist, ButterflyChromosomes.FIRE_RESIST);
    }

    @Override
    public ItemStack getIconStack() {
        return ButterflyDefinition.BlueWing.getMemberStack(this.mode == DatabaseMode.ACTIVE ? EnumFlutterType.BUTTERFLY : EnumFlutterType.CATERPILLAR);
    }
}

