/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import forestry.api.genetics.gatgets.IDatabaseTab;
import forestry.api.lepidopterology.genetics.ButterflyChromosomes;
import forestry.api.lepidopterology.genetics.EnumFlutterType;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.core.gui.elements.Alignment;
import forestry.core.gui.elements.DatabaseElement;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.gui.elements.ItemElement;
import forestry.core.gui.elements.layouts.FlexLayout;
import forestry.core.gui.elements.layouts.LayoutHelper;
import forestry.lepidopterology.genetics.ButterflyDefinition;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ButterflyProductsTab
implements IDatabaseTab<IButterfly> {
    ButterflyProductsTab() {
    }

    @Override
    public void createElements(DatabaseElement container, IButterfly individual, ItemStack itemStack) {
        NonNullList<ItemStack> cocoonLoot;
        NonNullList<ItemStack> caterpillarLoot;
        LayoutHelper groupHelper = container.layoutHelper((x, y) -> GuiElementFactory.horizontal(18, 2, FlexLayout.LEFT_MARGIN), 90, 0);
        NonNullList<ItemStack> butterflyLoot = individual.getGenome().getActiveAllele(ButterflyChromosomes.SPECIES).getButterflyLoot().getPossibleStacks();
        if (!butterflyLoot.isEmpty()) {
            container.translated("for.gui.loot.butterfly", new Object[0]).setAlign(Alignment.TOP_CENTER);
            butterflyLoot.forEach(stack -> groupHelper.add(new ItemElement(0, 0, (ItemStack)stack)));
            groupHelper.finish();
        }
        if (!(caterpillarLoot = individual.getGenome().getActiveAllele(ButterflyChromosomes.SPECIES).getCaterpillarLoot().getPossibleStacks()).isEmpty()) {
            container.translated("for.gui.loot.caterpillar", new Object[0]).setAlign(Alignment.TOP_CENTER);
            caterpillarLoot.forEach(stack -> groupHelper.add(new ItemElement(0, 0, (ItemStack)stack)));
            groupHelper.finish();
        }
        if (!(cocoonLoot = individual.getGenome().getActiveAllele(ButterflyChromosomes.COCOON).getCocoonLoot().getPossibleStacks()).isEmpty()) {
            container.translated("for.gui.loot.cocoon", new Object[0]).setAlign(Alignment.TOP_CENTER);
            cocoonLoot.forEach(stack -> groupHelper.add(new ItemElement(0, 0, (ItemStack)stack)));
            groupHelper.finish();
        }
    }

    @Override
    public ItemStack getIconStack() {
        return ButterflyDefinition.Aurora.getMemberStack(EnumFlutterType.SERUM);
    }
}

