/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics.alleles;

import forestry.api.core.ISetupListener;
import forestry.api.genetics.products.IDynamicProductList;
import forestry.api.lepidopterology.genetics.IAlleleButterflyCocoon;
import forestry.core.genetics.ProductListWrapper;
import forestry.lepidopterology.blocks.PropertyCocoon;
import genetics.api.alleles.AlleleCategorized;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;

public class AlleleButterflyCocoon
extends AlleleCategorized
implements IAlleleButterflyCocoon,
ISetupListener {
    public static final PropertyCocoon COCOON = new PropertyCocoon("cocoon");
    public static final IntegerProperty AGE = IntegerProperty.func_177719_a((String)"age", (int)0, (int)2);
    private ProductListWrapper loot = ProductListWrapper.create();
    private final String name;

    public AlleleButterflyCocoon(String name, boolean isDominant) {
        super("forestry", "cocoon", name, isDominant);
        this.name = name;
    }

    @Override
    public void onFinishSetup() {
        this.loot = this.loot.bake();
    }

    private static String getAgeKey(int age) {
        if (age == 0) {
            return "early";
        }
        if (age == 1) {
            return "middle";
        }
        return "late";
    }

    @Override
    public String getCocoonName() {
        return this.name;
    }

    @Override
    public ModelResourceLocation getCocoonItemModel(int age) {
        return new ModelResourceLocation("forestry:lepidopterology/cocoons/cocoon_" + this.name + "_" + AlleleButterflyCocoon.getAgeKey(age), "inventory");
    }

    @Override
    public void clearLoot() {
        this.loot = ProductListWrapper.create();
    }

    @Override
    public void bakeLoot() {
        this.loot = this.loot.bake();
    }

    @Override
    public void addLoot(ItemStack loot, float chance) {
        this.loot.addProduct(loot, chance);
    }

    @Override
    public IDynamicProductList getCocoonLoot() {
        return this.loot;
    }

    @Override
    public int compareTo(IAlleleButterflyCocoon o) {
        return 0;
    }
}

