/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.proxy;

import com.google.common.collect.ImmutableList;
import forestry.api.lepidopterology.genetics.ButterflyChromosomes;
import forestry.lepidopterology.features.LepidopterologyEntities;
import forestry.lepidopterology.proxy.ProxyLepidopterology;
import forestry.lepidopterology.render.ButterflyEntityRenderer;
import forestry.lepidopterology.render.ButterflyItemModel;
import forestry.lepidopterology.render.CocoonItemModel;
import forestry.modules.IClientModuleHandler;
import genetics.utils.AlleleUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@OnlyIn(value=Dist.CLIENT)
public class ProxyLepidopterologyClient
extends ProxyLepidopterology
implements IClientModuleHandler {
    @Override
    public void setupClient(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(LepidopterologyEntities.BUTTERFLY.entityType(), ButterflyEntityRenderer::new);
        AlleleUtils.forEach(ButterflyChromosomes.COCOON, allele -> {
            ImmutableList.Builder models = new ImmutableList.Builder();
            for (int age = 0; age < 3; ++age) {
                ModelLoader.addSpecialModel((ResourceLocation)allele.getCocoonItemModel(age));
            }
        });
    }

    @Override
    public void registerModels(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("forestry", "butterfly_ge"), (IModelLoader)new ButterflyItemModel.Loader());
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("forestry", "butterfly_cocoon"), (IModelLoader)new CocoonItemModel.Loader());
    }
}

