/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.render;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import forestry.lepidopterology.entities.EntityButterfly;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ButterflyModel
extends SegmentedModel<EntityButterfly> {
    private final ModelRenderer wingRight;
    private final ModelRenderer eyeRight;
    private final ModelRenderer eyeLeft;
    private final ModelRenderer wingLeft;
    private final ModelRenderer body;
    private final ImmutableList<ModelRenderer> parts;
    private float scale;

    public ButterflyModel() {
        this.field_78090_t = 64;
        this.field_78089_u = 32;
        this.wingRight = new ModelRenderer((Model)this, 0, 0);
        this.wingRight.func_228300_a_(-7.0f, 0.0f, -6.0f, 7.0f, 1.0f, 13.0f);
        this.wingRight.func_78793_a(-0.5f, 0.5f, 0.0f);
        this.wingRight.func_78787_b(64, 32);
        this.wingRight.field_78809_i = true;
        ButterflyModel.setRotation(this.wingRight, 0.0f, 0.0f, 0.0f);
        this.eyeRight = new ModelRenderer((Model)this, 40, 9);
        this.eyeRight.func_228300_a_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.eyeRight.func_78793_a(-1.1f, -0.5f, -4.5f);
        this.eyeRight.func_78787_b(64, 32);
        this.eyeRight.field_78809_i = true;
        ButterflyModel.setRotation(this.eyeRight, 0.0f, 0.0f, 0.0f);
        this.eyeLeft = new ModelRenderer((Model)this, 40, 7);
        this.eyeLeft.func_228300_a_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.eyeLeft.func_78793_a(0.1f, -0.5f, -4.5f);
        this.eyeLeft.func_78787_b(64, 32);
        this.eyeLeft.field_78809_i = true;
        ButterflyModel.setRotation(this.eyeLeft, 0.0f, 0.0f, 0.0f);
        this.wingLeft = new ModelRenderer((Model)this, 0, 14);
        this.wingLeft.func_228300_a_(0.0f, 0.0f, -6.0f, 7.0f, 1.0f, 13.0f);
        this.wingLeft.func_78793_a(0.5f, 0.5f, 0.0f);
        this.wingLeft.func_78787_b(64, 32);
        this.wingLeft.field_78809_i = true;
        ButterflyModel.setRotation(this.wingLeft, 0.0f, 0.0f, 0.0f);
        this.body = new ModelRenderer((Model)this, 40, 0);
        this.body.func_228300_a_(0.0f, 0.0f, -4.0f, 1.0f, 1.0f, 6.0f);
        this.body.func_78793_a(0.0f, 0.0f, 0.0f);
        this.body.func_78787_b(64, 32);
        this.body.field_78809_i = true;
        ButterflyModel.setRotation(this.body, 0.0f, 0.0f, 0.7853982f);
        this.parts = ImmutableList.of((Object)this.wingRight, (Object)this.eyeLeft, (Object)this.eyeRight, (Object)this.wingLeft, (Object)this.body);
    }

    public ImmutableList<ModelRenderer> parts() {
        return this.parts;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void func_225598_a_(MatrixStack transformation, IVertexBuilder builder, int packedLight, int packetLight2, float ageInTicks, float netHeadYaw, float headPitch, float alpha) {
        transformation.func_227862_a_(this.scale, this.scale, this.scale);
        transformation.func_227861_a_(0.0, (double)(1.45f / this.scale), 0.0);
        super.func_225598_a_(transformation, builder, packedLight, packetLight2, ageInTicks, netHeadYaw, headPitch, alpha);
    }

    public void setupAnim(EntityButterfly entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.wingRight.field_78808_h = MathHelper.func_76134_b((float)(ageInTicks * 1.3f)) * (float)Math.PI * 0.25f;
        this.wingLeft.field_78808_h = -this.wingRight.field_78808_h;
    }

    private static void setRotation(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }
}

