/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.tiles;

import com.google.common.base.Preconditions;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.IButterflyCocoon;
import forestry.api.lepidopterology.genetics.ButterflyChromosomes;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.packets.PacketTileStream;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.owner.OwnerHandler;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.NBTUtilForestry;
import forestry.core.utils.NetworkUtil;
import forestry.lepidopterology.features.LepidopterologyTiles;
import forestry.lepidopterology.genetics.Butterfly;
import forestry.lepidopterology.genetics.ButterflyDefinition;
import genetics.api.alleles.IAllele;
import genetics.api.individual.IGenome;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileCocoon
extends TileEntity
implements IStreamable,
IOwnedTile,
IButterflyCocoon {
    private final OwnerHandler ownerHandler = new OwnerHandler();
    private int age;
    private int maturationTime;
    private IButterfly caterpillar = ButterflyDefinition.CabbageWhite.createIndividual();
    private boolean isSolid;

    public TileCocoon() {
        super(LepidopterologyTiles.COCOON.tileType());
    }

    public TileCocoon(boolean isSolid) {
        super(isSolid ? LepidopterologyTiles.SOLID_COCOON.tileType() : LepidopterologyTiles.COCOON.tileType());
        this.isSolid = isSolid;
        if (isSolid) {
            this.age = 2;
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        super.func_230337_a_(state, compoundNBT);
        if (compoundNBT.func_74764_b("Caterpillar")) {
            this.caterpillar = new Butterfly(compoundNBT.func_74775_l("Caterpillar"));
        }
        this.ownerHandler.read(compoundNBT);
        this.age = compoundNBT.func_74762_e("Age");
        this.maturationTime = compoundNBT.func_74762_e("CATMAT");
        this.isSolid = compoundNBT.func_74767_n("isSolid");
    }

    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT = super.func_189515_b(compoundNBT);
        CompoundNBT subcompound = new CompoundNBT();
        this.caterpillar.write(subcompound);
        compoundNBT.func_218657_a("Caterpillar", (INBT)subcompound);
        this.ownerHandler.write(compoundNBT);
        compoundNBT.func_74768_a("Age", this.age);
        compoundNBT.func_74768_a("CATMAT", this.maturationTime);
        compoundNBT.func_74757_a("isSolid", this.isSolid);
        return compoundNBT;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        IButterfly caterpillar = this.getCaterpillar();
        String speciesUID = caterpillar.getIdentifier();
        data.func_180714_a(speciesUID);
        data.writeInt(this.age);
    }

    @Override
    public void readData(PacketBufferForestry data) {
        String speciesUID = data.func_218666_n();
        IButterfly caterpillar = TileCocoon.getButterfly(speciesUID);
        this.setCaterpillar(caterpillar);
        this.age = data.readInt();
    }

    private static IButterfly getButterfly(String speciesUID) {
        IAllele[] butterflyTemplate = ButterflyManager.butterflyRoot.getTemplates().getTemplate(speciesUID);
        Preconditions.checkNotNull((Object)butterflyTemplate, (String)"Could not find butterfly template for species: %s", (Object)speciesUID);
        return (IButterfly)ButterflyManager.butterflyRoot.templateAsIndividual(butterflyTemplate);
    }

    @Override
    public IOwnerHandler getOwnerHandler() {
        return this.ownerHandler;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        return NBTUtilForestry.writeStreamableToNbt(this, tag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        int oldAge = this.age;
        super.handleUpdateTag(state, tag);
        NBTUtilForestry.readStreamableFromNbt(this, tag);
        if (oldAge != this.age) {
            Minecraft.func_71410_x().field_71438_f.func_215328_b(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        CompoundNBT nbt = pkt.func_148857_g();
        this.handleUpdateTag(this.func_195044_w(), nbt);
    }

    public void onBlockTick() {
        ++this.maturationTime;
        IGenome caterpillarGenome = this.caterpillar.getGenome();
        int caterpillarMatureTime = Math.round((float)caterpillarGenome.getActiveValue(ButterflyChromosomes.LIFESPAN).intValue() / (float)(caterpillarGenome.getActiveValue(ButterflyChromosomes.FERTILITY) * 2));
        if (this.maturationTime >= caterpillarMatureTime) {
            if (this.age < 2) {
                ++this.age;
                this.maturationTime = 0;
                BlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 0);
            } else if (this.caterpillar.canTakeFlight(this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p())) {
                NonNullList<ItemStack> cocoonDrops = this.caterpillar.getCocoonDrop(this);
                for (ItemStack drop : cocoonDrops) {
                    ItemStackUtil.dropItemStackAsEntity(drop, this.field_145850_b, this.field_174879_c);
                }
                this.field_145850_b.func_175656_a(this.func_174877_v(), Blocks.field_150350_a.func_176223_P());
                TileCocoon.attemptButterflySpawn(this.field_145850_b, this.caterpillar, this.func_174877_v());
            }
        }
    }

    private boolean isListEmpty(NonNullList<ItemStack> cocoonDrops) {
        if (cocoonDrops.isEmpty()) {
            return true;
        }
        for (ItemStack stack : cocoonDrops) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private static void attemptButterflySpawn(World world, IButterfly butterfly, BlockPos pos) {
        MobEntity entityLiving = ButterflyManager.butterflyRoot.spawnButterflyInWorld(world, butterfly.copy(), pos.func_177958_n(), (float)pos.func_177956_o() + 0.1f, pos.func_177952_p());
        Log.trace("A caterpillar '%s' hatched at %s/%s/%s.", butterfly.getDisplayName(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public BlockPos getCoordinates() {
        return this.func_174877_v();
    }

    @Override
    public IButterfly getCaterpillar() {
        return this.caterpillar;
    }

    @Override
    public void setCaterpillar(IButterfly butterfly) {
        this.caterpillar = butterfly;
        this.sendNetworkUpdate();
    }

    private void sendNetworkUpdate() {
        NetworkUtil.sendNetworkPacket(new PacketTileStream(this), this.field_174879_c, this.field_145850_b);
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public NonNullList<ItemStack> getCocoonDrops() {
        return this.caterpillar.getCocoonDrop(this);
    }

    @Override
    public boolean isSolid() {
        return this.isSolid;
    }
}

