/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IStamps;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.utils.InventoryUtil;
import forestry.mail.MailAddress;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.StringUtils;

public class Letter
implements ILetter {
    private static final Random rand = new Random();
    public static final short SLOT_ATTACHMENT_1 = 0;
    public static final short SLOT_ATTACHMENT_COUNT = 18;
    public static final short SLOT_POSTAGE_1 = 18;
    public static final short SLOT_POSTAGE_COUNT = 4;
    private boolean isProcessed = false;
    private IMailAddress sender;
    @Nullable
    private IMailAddress recipient;
    private String text = "";
    private final InventoryAdapter inventory = new InventoryAdapter(22, "INV");
    private final String uid;

    public Letter(IMailAddress sender, IMailAddress recipient) {
        this.sender = sender;
        this.recipient = recipient;
        this.uid = String.valueOf(rand.nextInt());
    }

    public Letter(CompoundNBT compoundNBT) {
        this.isProcessed = compoundNBT.func_74767_n("PRC");
        this.sender = new MailAddress(compoundNBT.func_74775_l("SDR"));
        this.recipient = new MailAddress(compoundNBT.func_74775_l("RC"));
        this.text = compoundNBT.func_74779_i("TXT");
        this.uid = compoundNBT.func_74779_i("UID");
        this.inventory.read(compoundNBT);
    }

    @Override
    public CompoundNBT write(CompoundNBT compoundNBT) {
        compoundNBT.func_74757_a("PRC", this.isProcessed);
        CompoundNBT subcompound = new CompoundNBT();
        this.sender.write(subcompound);
        compoundNBT.func_218657_a("SDR", (INBT)subcompound);
        if (this.recipient != null) {
            subcompound = new CompoundNBT();
            this.recipient.write(subcompound);
            compoundNBT.func_218657_a("RC", (INBT)subcompound);
        }
        compoundNBT.func_74778_a("TXT", this.text);
        compoundNBT.func_74778_a("UID", this.uid);
        this.inventory.write(compoundNBT);
        return compoundNBT;
    }

    @Override
    public NonNullList<ItemStack> getPostage() {
        return InventoryUtil.getStacks((IInventory)this.inventory, 18, 4);
    }

    @Override
    public NonNullList<ItemStack> getAttachments() {
        return InventoryUtil.getStacks((IInventory)this.inventory, 0, 18);
    }

    @Override
    public int countAttachments() {
        int count = 0;
        for (ItemStack stack : this.getAttachments()) {
            if (stack.func_190926_b()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void addAttachment(ItemStack itemstack) {
        InventoryUtil.tryAddStack((IInventory)this.inventory, itemstack, false);
    }

    @Override
    public void addAttachments(NonNullList<ItemStack> itemstacks) {
        for (ItemStack stack : itemstacks) {
            this.addAttachment(stack);
        }
    }

    @Override
    public void invalidatePostage() {
        for (int i = 18; i < 22; ++i) {
            this.inventory.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    @Override
    public void setProcessed(boolean flag) {
        this.isProcessed = flag;
    }

    @Override
    public boolean isProcessed() {
        return this.isProcessed;
    }

    @Override
    public boolean isMailable() {
        return !this.isProcessed && this.recipient != null;
    }

    @Override
    public boolean isPostPaid() {
        int posted = 0;
        for (ItemStack stamp : this.getPostage()) {
            if (stamp.func_190926_b() || !(stamp.func_77973_b() instanceof IStamps)) continue;
            posted += ((IStamps)stamp.func_77973_b()).getPostage(stamp).getValue() * stamp.func_190916_E();
        }
        return posted >= this.requiredPostage();
    }

    @Override
    public int requiredPostage() {
        int required = 1;
        for (ItemStack attach : this.getAttachments()) {
            if (attach.func_190926_b()) continue;
            ++required;
        }
        return required;
    }

    @Override
    public void addStamps(ItemStack stamps) {
        InventoryUtil.tryAddStack((IInventory)this.inventory, stamps, 18, 4, false);
    }

    @Override
    public boolean hasRecipient() {
        return this.recipient != null && !StringUtils.isBlank((CharSequence)this.recipient.getName());
    }

    @Override
    public void setSender(IMailAddress address) {
        this.sender = address;
    }

    @Override
    public IMailAddress getSender() {
        return this.sender;
    }

    @Override
    public void setRecipient(@Nullable IMailAddress address) {
        this.recipient = address;
    }

    @Override
    @Nullable
    public IMailAddress getRecipient() {
        return this.recipient;
    }

    @Override
    public String getRecipientString() {
        if (this.recipient == null) {
            return "";
        }
        return this.recipient.getName();
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void addTooltip(List<ITextComponent> list) {
        if (StringUtils.isNotBlank((CharSequence)this.sender.getName())) {
            list.add((ITextComponent)new TranslationTextComponent("for.gui.mail.from").func_240702_b_(": " + this.sender.getName()).func_240699_a_(TextFormatting.GRAY));
        }
        if (this.recipient != null) {
            list.add((ITextComponent)new TranslationTextComponent("for.gui.mail.to").func_240702_b_(": " + this.getRecipientString()).func_240699_a_(TextFormatting.GRAY));
        }
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int var1) {
        return this.inventory.func_70301_a(var1);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return this.inventory.func_70298_a(var1, var2);
    }

    public ItemStack func_70304_b(int index) {
        return this.inventory.func_70304_b(index);
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.inventory.func_70299_a(var1, var2);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70296_d() {
        this.inventory.func_70296_d();
    }

    public boolean func_70300_a(PlayerEntity var1) {
        return true;
    }

    public void func_174889_b(PlayerEntity var1) {
        this.inventory.func_174889_b(var1);
    }

    public void func_174886_c(PlayerEntity var1) {
        this.inventory.func_174886_c(var1);
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this.inventory.func_94041_b(i, itemstack);
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }
}

