/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.api.mail.ILetter;
import forestry.mail.features.MailItems;
import forestry.mail.items.ItemLetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class LetterProperties {
    public static ItemStack createStampedLetterStack(ILetter letter) {
        ItemLetter.Size size = LetterProperties.getSize(letter);
        return MailItems.LETTERS.stack(size, ItemLetter.State.STAMPED, 1);
    }

    public static ItemStack closeLetter(ItemStack parent, ILetter letter) {
        Item item = parent.func_77973_b();
        if (!(item instanceof ItemLetter)) {
            return parent;
        }
        ItemLetter itemLetter = (ItemLetter)item;
        ItemLetter.State state = itemLetter.getState();
        ItemLetter.Size size = itemLetter.getSize();
        switch (state) {
            case OPENED: {
                if (letter.countAttachments() > 0) break;
                state = ItemLetter.State.EMPTIED;
                break;
            }
            case FRESH: 
            case STAMPED: {
                state = letter.isMailable() && letter.isPostPaid() ? ItemLetter.State.STAMPED : ItemLetter.State.FRESH;
                size = LetterProperties.getSize(letter);
                break;
            }
        }
        ItemStack ret = MailItems.LETTERS.stack(size, state, parent.func_190916_E());
        ret.func_77982_d(parent.func_77978_p());
        letter.write(parent.func_77978_p());
        return ret;
    }

    public static ItemStack openLetter(ItemStack parent) {
        Item item = parent.func_77973_b();
        if (!(item instanceof ItemLetter)) {
            return parent;
        }
        ItemLetter itemLetter = (ItemLetter)item;
        ItemLetter.State state = itemLetter.getState();
        if (state == ItemLetter.State.FRESH || state == ItemLetter.State.STAMPED) {
            ItemLetter.Size size = itemLetter.getSize();
            ItemStack ret = MailItems.LETTERS.stack(size, state, parent.func_190916_E());
            ret.func_77982_d(parent.func_77978_p());
            return ret;
        }
        return parent;
    }

    private static ItemLetter.Size getSize(ILetter letter) {
        int count = letter.countAttachments();
        if (count > 5) {
            return ItemLetter.Size.BIG;
        }
        if (count > 1) {
            return ItemLetter.Size.SMALL;
        }
        return ItemLetter.Size.EMPTY;
    }
}

