/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.api.mail.EnumAddressee;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostOffice;
import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.IPostalState;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.PostManager;
import forestry.core.render.TextureManagerForestry;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.PlayerUtil;
import forestry.core.utils.Translator;
import forestry.mail.EnumDeliveryState;
import forestry.mail.POBox;
import forestry.mail.PostRegistry;
import forestry.mail.network.packets.PacketPOBoxInfoResponse;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PostalCarrier
implements IPostalCarrier {
    private final String iconID;
    private final EnumAddressee type;

    public PostalCarrier(EnumAddressee type) {
        this.iconID = "mail/carrier." + (Object)((Object)type);
        this.type = type;
    }

    @Override
    public EnumAddressee getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return Translator.translateToLocal("for.gui.addressee." + (Object)((Object)this.type));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getSprite() {
        return TextureManagerForestry.getInstance().getDefault(this.iconID);
    }

    @Override
    public IPostalState deliverLetter(ServerWorld world, IPostOffice office, IMailAddress recipient, ItemStack letterStack, boolean doDeliver) {
        if (this.type == EnumAddressee.TRADER) {
            return PostalCarrier.handleTradeLetter(world, recipient, letterStack, doDeliver);
        }
        return PostalCarrier.storeInPOBox(world, recipient, letterStack);
    }

    private static IPostalState handleTradeLetter(ServerWorld world, IMailAddress recipient, ItemStack letterStack, boolean doLodge) {
        ITradeStation trade = PostManager.postRegistry.getTradeStation(world, recipient);
        if (trade == null) {
            return EnumDeliveryState.NO_MAILBOX;
        }
        return trade.handleLetter(world, recipient, letterStack, doLodge);
    }

    private static EnumDeliveryState storeInPOBox(ServerWorld world, IMailAddress recipient, ItemStack letterStack) {
        POBox pobox = PostRegistry.getPOBox(world, recipient);
        if (pobox == null) {
            return EnumDeliveryState.NO_MAILBOX;
        }
        if (!pobox.storeLetter(letterStack.func_77946_l())) {
            return EnumDeliveryState.MAILBOX_FULL;
        }
        PlayerEntity player = PlayerUtil.getPlayer((World)world, recipient.getPlayerProfile());
        if (player instanceof ServerPlayerEntity) {
            NetworkUtil.sendToPlayer(new PacketPOBoxInfoResponse(pobox.getPOBoxInfo()), player);
        }
        return EnumDeliveryState.OK;
    }
}

