/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.commands;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.ITradeStationInfo;
import forestry.api.mail.PostManager;
import forestry.core.utils.StringUtil;
import forestry.mail.MailAddress;
import genetics.commands.CommandHelpers;
import genetics.commands.PermLevel;
import java.util.function.Predicate;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CommandMail {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"mail").then(CommandMailTrades.register())).then(CommandMailVirtualize.register());
    }

    public static class CommandMailVirtualize {
        public static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"virtualize").requires((Predicate)PermLevel.ADMIN)).executes(CommandMailVirtualize::execute);
        }

        public static int execute(CommandContext<CommandSource> context) throws CommandSyntaxException {
            MailAddress address;
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            World world = player.func_130014_f_();
            ITradeStation trade = PostManager.postRegistry.getTradeStation((ServerWorld)world, address = new MailAddress(player.func_146103_bH()));
            if (trade == null) {
                Style red = Style.field_240709_b_;
                red.func_240712_a_(TextFormatting.RED);
                CommandHelpers.sendLocalizedChatMessage((CommandSource)context.getSource(), red, "for.chat.command.forestry.mail.virtualize.no_tradestation", player.func_145748_c_());
                return 0;
            }
            trade.setVirtual(!trade.isVirtual());
            Style green = Style.field_240709_b_;
            green.func_240712_a_(TextFormatting.GREEN);
            CommandHelpers.sendLocalizedChatMessage((CommandSource)context.getSource(), green, "for.chat.command.forestry.mail.virtualize.set", trade.getAddress().getName(), trade.isVirtual());
            return 1;
        }
    }

    public static class CommandMailTrades {
        public static ArgumentBuilder<CommandSource, ?> register() {
            return Commands.func_197057_a((String)"trades").executes(CommandMailTrades::execute);
        }

        public static int execute(CommandContext<CommandSource> context) throws CommandSyntaxException {
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            ServerWorld world = (ServerWorld)player.field_70170_p;
            for (ITradeStation trade : PostManager.postRegistry.getPostOffice(world).getActiveTradeStations((World)world).values()) {
                CommandHelpers.sendChatMessage((CommandSource)context.getSource(), CommandMailTrades.makeTradeListEntry(trade.getTradeInfo()));
            }
            return 1;
        }

        private static String makeTradeListEntry(ITradeStationInfo info) {
            TextFormatting formatting = info.getState().isOk() ? TextFormatting.GREEN : TextFormatting.RED;
            String tradegood = "[ ? ]";
            if (!info.getTradegood().func_190926_b()) {
                tradegood = info.getTradegood().func_190916_E() + "x" + info.getTradegood().func_200301_q();
            }
            String demand = "[ ? ]";
            if (!info.getRequired().isEmpty()) {
                demand = "";
                for (ItemStack dmd : info.getRequired()) {
                    demand = StringUtil.append(", ", demand, dmd.func_190916_E() + "x" + dmd.func_200301_q());
                }
            }
            return String.format("%s%-12s | %-20s | %s", formatting, info.getAddress().getName(), tradegood, demand);
        }
    }
}

