/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.ITradeStationInfo;
import forestry.core.config.SessionVars;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.widgets.ItemStackWidget;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.render.ColourProperties;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.Translator;
import forestry.mail.gui.ContainerCatalogue;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiCatalogue
extends GuiForestry<ContainerCatalogue> {
    private static final String boldUnderline = TextFormatting.BOLD.toString() + TextFormatting.UNDERLINE;
    private Button buttonFilter;
    private Button buttonUse;
    private final List<ItemStackWidget> tradeInfoWidgets = new ArrayList<ItemStackWidget>();

    public GuiCatalogue(ContainerCatalogue container, PlayerInventory inv, ITextComponent title) {
        super(new ResourceLocation("textures/gui/book.png"), container, inv, title);
        this.field_146999_f = 192;
        this.field_147000_g = 192;
        this.buttonFilter = new Button(this.field_230708_k_ / 2 - 44, this.field_147009_r + 150, 42, 20, (ITextComponent)new TranslationTextComponent("for.gui.mail.filter.all"), b -> this.actionPerformed(4));
        this.buttonUse = new Button(this.field_230708_k_ / 2, this.field_147009_r + 150, 42, 20, (ITextComponent)new TranslationTextComponent("for.gui.mail.address.copy"), b -> this.actionPerformed(5));
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        Minecraft.func_71410_x().field_195559_v.func_197967_a(true);
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 44, this.field_147009_r + 150, 12, 20, (ITextComponent)new StringTextComponent(">"), b -> this.actionPerformed(2)));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 58, this.field_147009_r + 150, 12, 20, (ITextComponent)new StringTextComponent("<"), b -> this.actionPerformed(3)));
        this.buttonFilter = new Button(this.field_230708_k_ / 2 - 44, this.field_147009_r + 150, 42, 20, (ITextComponent)new TranslationTextComponent("for.gui.mail.filter.all"), b -> this.actionPerformed(4));
        this.func_230480_a_((Widget)this.buttonFilter);
        this.buttonUse = new Button(this.field_230708_k_ / 2, this.field_147009_r + 150, 42, 20, (ITextComponent)new TranslationTextComponent("for.gui.mail.address.copy"), b -> this.actionPerformed(5));
        this.func_230480_a_((Widget)this.buttonUse);
    }

    public void func_231164_f_() {
        Minecraft.func_71410_x().field_195559_v.func_197967_a(false);
        super.func_231164_f_();
    }

    @Override
    protected void func_230450_a_(MatrixStack transform, float partialTicks, int mouseY, int mouseX) {
        super.func_230450_a_(transform, partialTicks, mouseY, mouseX);
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(transform, String.format("%s / %s", ((ContainerCatalogue)this.container).getPageNumber(), ((ContainerCatalogue)this.container).getPageCount()), (float)(this.field_147003_i + this.field_146999_f - 72), (float)(this.field_147009_r + 12), ColourProperties.INSTANCE.get("gui.book"));
        this.clearTradeInfoWidgets();
        ITradeStationInfo tradeInfo = ((ContainerCatalogue)this.container).getTradeInfo();
        if (tradeInfo != null) {
            this.drawTradePreview(transform, tradeInfo, this.field_147003_i + 38, this.field_147009_r + 30);
            this.buttonUse.field_230694_p_ = tradeInfo.getState().isOk();
        } else {
            this.drawNoTrade(this.field_147003_i + 38, this.field_147009_r + 30);
            this.buttonUse.field_230694_p_ = false;
        }
        this.buttonFilter.func_238482_a_((ITextComponent)new TranslationTextComponent("for.gui.mail.filter." + ((ContainerCatalogue)this.container).getFilterIdent()));
    }

    private void drawNoTrade(int x, int y) {
        Minecraft.func_71410_x().field_71466_p.func_238418_a_((ITextProperties)new TranslationTextComponent("for.gui.mail.notrades"), x, y + 18, 119, ColourProperties.INSTANCE.get("gui.book"));
    }

    private void drawTradePreview(MatrixStack transform, ITradeStationInfo tradeInfo, int x, int y) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_238421_b_(transform, boldUnderline + tradeInfo.getAddress().getName(), (float)x, (float)y, ColourProperties.INSTANCE.get("gui.book"));
        fontRenderer.func_238421_b_(transform, String.format(Translator.translateToLocal("for.gui.mail.willtrade"), tradeInfo.getOwner().getName()), (float)x, (float)(y + 18), ColourProperties.INSTANCE.get("gui.book"));
        this.addTradeInfoWidget(new ItemStackWidget(this.widgetManager, x - this.field_147003_i, y - this.field_147009_r + 28, tradeInfo.getTradegood()));
        fontRenderer.func_238421_b_(transform, Translator.translateToLocal("for.gui.mail.tradefor"), (float)x, (float)(y + 46), ColourProperties.INSTANCE.get("gui.book"));
        for (int i = 0; i < tradeInfo.getRequired().size(); ++i) {
            ItemStack itemStack = (ItemStack)tradeInfo.getRequired().get(i);
            this.addTradeInfoWidget(new ItemStackWidget(this.widgetManager, x - this.field_147003_i + i * 18, y - this.field_147009_r + 56, itemStack));
        }
        if (tradeInfo.getState().isOk()) {
            fontRenderer.func_238418_a_((ITextProperties)((IFormattableTextComponent)tradeInfo.getState().getDescription()).func_240699_a_(TextFormatting.DARK_GREEN), x, y + 82, 119, ColourProperties.INSTANCE.get("gui.book"));
        } else {
            fontRenderer.func_238418_a_((ITextProperties)((IFormattableTextComponent)tradeInfo.getState().getDescription()).func_240699_a_(TextFormatting.DARK_RED), x, y + 82, 119, ColourProperties.INSTANCE.get("gui.book"));
        }
    }

    private void addTradeInfoWidget(ItemStackWidget widget) {
        this.tradeInfoWidgets.add(widget);
        this.widgetManager.add(widget);
    }

    private void clearTradeInfoWidgets() {
        for (forestry.core.gui.widgets.Widget widget : this.tradeInfoWidgets) {
            this.widgetManager.remove(widget);
        }
        this.tradeInfoWidgets.clear();
    }

    protected void actionPerformed(int id) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        switch (id) {
            case 0: {
                player.func_71053_j();
                break;
            }
            case 2: {
                NetworkUtil.sendToServer(new PacketGuiSelectRequest(0, 0));
                break;
            }
            case 3: {
                NetworkUtil.sendToServer(new PacketGuiSelectRequest(1, 0));
                break;
            }
            case 4: {
                NetworkUtil.sendToServer(new PacketGuiSelectRequest(2, 0));
                break;
            }
            case 5: {
                ITradeStationInfo info = ((ContainerCatalogue)this.container).getTradeInfo();
                if (info != null) {
                    SessionVars.setStringVar("mail.letter.recipient", info.getAddress().getName());
                    SessionVars.setStringVar("mail.letter.addressee", EnumAddressee.TRADER.toString());
                }
                player.func_71053_j();
            }
        }
    }

    @Override
    protected void addLedgers() {
    }
}

