/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.IMailAddress;
import forestry.core.config.SessionVars;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.GuiTextBox;
import forestry.core.gui.widgets.ItemStackWidget;
import forestry.core.gui.widgets.Widget;
import forestry.core.render.ColourProperties;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.Translator;
import forestry.mail.gui.AddresseeSlot;
import forestry.mail.gui.ContainerLetter;
import forestry.mail.inventory.ItemInventoryLetter;
import forestry.mail.network.packets.PacketLetterInfoRequest;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

public class GuiLetter
extends GuiForestry<ContainerLetter> {
    private final ItemInventoryLetter itemInventory;
    private final boolean isProcessedLetter;
    private boolean checkedSessionVars;
    private TextFieldWidget address;
    private GuiTextBox text;
    private boolean addressFocus;
    private boolean textFocus;
    private final ArrayList<Widget> tradeInfoWidgets;

    public GuiLetter(ContainerLetter container, PlayerInventory inv, ITextComponent title) {
        super("textures/gui/letter.png", container, inv, title);
        this.field_230706_i_ = Minecraft.func_71410_x();
        this.itemInventory = (ItemInventoryLetter)container.getItemInventory();
        this.field_146999_f = 194;
        this.field_147000_g = 227;
        this.isProcessedLetter = container.getLetter().isProcessed();
        this.widgetManager.add(new AddresseeSlot(this.widgetManager, 16, 12, container));
        this.tradeInfoWidgets = new ArrayList();
        this.address = new TextFieldWidget(this.field_230706_i_.field_71466_p, this.field_147003_i + 46, this.field_147009_r + 13, 93, 13, null);
        this.text = new GuiTextBox(this.field_230706_i_.field_71466_p, this.field_147003_i + 17, this.field_147009_r + 31, 122, 57);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.address = new TextFieldWidget(this.field_230706_i_.field_71466_p, this.field_147003_i + 46, this.field_147009_r + 13, 93, 13, null);
        IMailAddress recipient = ((ContainerLetter)this.container).getRecipient();
        if (recipient != null) {
            this.address.func_146180_a(recipient.getName());
        }
        this.text = new GuiTextBox(this.field_230706_i_.field_71466_p, this.field_147003_i + 17, this.field_147009_r + 31, 122, 57);
        this.text.func_146203_f(128);
        if (!((ContainerLetter)this.container).getText().isEmpty()) {
            this.text.func_146180_a(((ContainerLetter)this.container).getText());
        }
    }

    @Override
    public boolean func_231046_a_(int key, int scanCode, int modifiers) {
        if (this.address.func_230999_j_()) {
            if (scanCode == 257) {
                this.address.func_146195_b(false);
            } else {
                this.address.func_231046_a_(key, scanCode, modifiers);
            }
            return true;
        }
        if (this.text.func_230999_j_()) {
            if (scanCode == 257) {
                if (GuiLetter.func_231173_s_()) {
                    this.text.func_146180_a(this.text.func_146179_b() + "\n");
                } else {
                    this.text.func_146195_b(false);
                }
            } else if (scanCode == 264) {
                this.text.advanceLine();
            } else if (scanCode == 265) {
                this.text.regressLine();
            } else if (this.text.moreLinesAllowed() || scanCode == 261 || scanCode == 92) {
                this.text.func_231046_a_(key, scanCode, modifiers);
            }
            return true;
        }
        return super.func_231046_a_(key, scanCode, modifiers);
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (super.func_231044_a_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        this.address.func_231044_a_(mouseX, mouseY, mouseButton);
        this.text.func_231044_a_(mouseX, mouseY, mouseButton);
        return true;
    }

    @Override
    protected void func_230450_a_(MatrixStack transform, float partialTicks, int mouseY, int mouseX) {
        EnumAddressee recipientType;
        String recipient;
        if (!this.isProcessedLetter && !this.checkedSessionVars) {
            this.checkedSessionVars = true;
            this.setFromSessionVars();
            recipient = this.address.func_146179_b();
            recipientType = ((ContainerLetter)this.container).getCarrierType();
            this.setRecipient(recipient, recipientType);
        }
        if (this.addressFocus != this.address.func_230999_j_() && StringUtils.isNotBlank((CharSequence)(recipient = this.address.func_146179_b()))) {
            recipientType = ((ContainerLetter)this.container).getCarrierType();
            this.setRecipient(recipient, recipientType);
        }
        this.addressFocus = this.address.func_230999_j_();
        if (this.textFocus != this.text.func_230999_j_()) {
            this.setText();
        }
        this.textFocus = this.text.func_230999_j_();
        super.func_230450_a_(transform, partialTicks, mouseY, mouseX);
        if (this.isProcessedLetter) {
            this.field_230706_i_.field_71466_p.func_238421_b_(transform, this.address.func_146179_b(), (float)(this.field_147003_i + 49), (float)(this.field_147009_r + 16), ColourProperties.INSTANCE.get("gui.mail.lettertext"));
            this.field_230706_i_.field_71466_p.func_238418_a_((ITextProperties)new StringTextComponent(this.text.func_146179_b()), this.field_147003_i + 20, this.field_147009_r + 34, 119, ColourProperties.INSTANCE.get("gui.mail.lettertext"));
        } else {
            this.clearTradeInfoWidgets();
            this.address.func_230430_a_(transform, mouseX, mouseY, partialTicks);
            if (((ContainerLetter)this.container).getCarrierType() == EnumAddressee.TRADER) {
                this.drawTradePreview(transform, 18, 32);
            } else {
                this.text.func_230430_a_(transform, mouseX, mouseY, partialTicks);
            }
        }
    }

    private void drawTradePreview(MatrixStack transform, int x, int y) {
        TranslationTextComponent infoString = null;
        if (((ContainerLetter)this.container).getTradeInfo() == null) {
            infoString = new TranslationTextComponent("for.gui.mail.no.trader");
        } else if (((ContainerLetter)this.container).getTradeInfo().getTradegood().func_190926_b()) {
            infoString = new TranslationTextComponent("for.gui.mail.nothing.to.trade");
        } else if (!((ContainerLetter)this.container).getTradeInfo().getState().isOk()) {
            infoString = ((ContainerLetter)this.container).getTradeInfo().getState().getDescription();
        }
        if (infoString != null) {
            this.field_230706_i_.field_71466_p.func_238418_a_((ITextProperties)infoString, this.field_147003_i + x, this.field_147009_r + y, 119, ColourProperties.INSTANCE.get("gui.mail.lettertext"));
            return;
        }
        this.field_230706_i_.field_71466_p.func_238421_b_(transform, Translator.translateToLocal("for.gui.mail.pleasesend"), (float)(this.field_147003_i + x), (float)(this.field_147009_r + y), ColourProperties.INSTANCE.get("gui.mail.lettertext"));
        this.addTradeInfoWidget(new ItemStackWidget(this.widgetManager, x, y + 10, ((ContainerLetter)this.container).getTradeInfo().getTradegood()));
        this.field_230706_i_.field_71466_p.func_238421_b_(transform, Translator.translateToLocal("for.gui.mail.foreveryattached"), (float)(this.field_147003_i + x), (float)(this.field_147009_r + y + 28), ColourProperties.INSTANCE.get("gui.mail.lettertext"));
        for (int i = 0; i < ((ContainerLetter)this.container).getTradeInfo().getRequired().size(); ++i) {
            this.addTradeInfoWidget(new ItemStackWidget(this.widgetManager, x + i * 18, y + 38, (ItemStack)((ContainerLetter)this.container).getTradeInfo().getRequired().get(i)));
        }
    }

    private void addTradeInfoWidget(Widget widget) {
        this.tradeInfoWidgets.add(widget);
        this.widgetManager.add(widget);
    }

    private void clearTradeInfoWidgets() {
        for (Widget widget : this.tradeInfoWidgets) {
            this.widgetManager.remove(widget);
        }
        this.tradeInfoWidgets.clear();
    }

    @Override
    public void func_231175_as__() {
        String recipientName = this.address.func_146179_b();
        EnumAddressee recipientType = ((ContainerLetter)this.container).getCarrierType();
        this.setRecipient(recipientName, recipientType);
        this.setText();
        this.field_230706_i_.field_195559_v.func_197967_a(false);
        super.func_231175_as__();
    }

    private void setFromSessionVars() {
        if (SessionVars.getStringVar("mail.letter.recipient") == null) {
            return;
        }
        String recipient = SessionVars.getStringVar("mail.letter.recipient");
        String typeName = SessionVars.getStringVar("mail.letter.addressee");
        if (StringUtils.isNotBlank((CharSequence)recipient) && StringUtils.isNotBlank((CharSequence)typeName)) {
            this.address.func_146180_a(recipient);
            EnumAddressee type = EnumAddressee.fromString(typeName);
            ((ContainerLetter)this.container).setCarrierType(type);
        }
        SessionVars.clearStringVar("mail.letter.recipient");
        SessionVars.clearStringVar("mail.letter.addressee");
    }

    private void setRecipient(String recipientName, EnumAddressee type) {
        if (this.isProcessedLetter || StringUtils.isBlank((CharSequence)recipientName)) {
            return;
        }
        PacketLetterInfoRequest packet = new PacketLetterInfoRequest(recipientName, type);
        NetworkUtil.sendToServer(packet);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setText() {
        if (this.isProcessedLetter) {
            return;
        }
        ((ContainerLetter)this.container).setText(this.text.func_146179_b());
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger(this.itemInventory);
        this.addHintLedger("letter");
    }
}

