/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules;

import forestry.core.network.IPacketRegistry;
import forestry.core.utils.ForgeUtils;
import forestry.modules.BlankForestryModule;
import forestry.modules.CommonModuleHandler;
import forestry.modules.IClientModuleHandler;
import forestry.modules.ISidedModuleHandler;
import java.util.function.Consumer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientModuleHandler
extends CommonModuleHandler {
    public ClientModuleHandler() {
        ForgeUtils.registerSubscriber(this);
    }

    @Override
    protected void registerPackages(IPacketRegistry packetRegistry) {
        super.registerPackages(packetRegistry);
        packetRegistry.registerPacketsClient();
    }

    @SubscribeEvent
    public void registerSprites(TextureStitchEvent.Pre event) {
        this.modules.forEach(module -> this.actOnHandler((BlankForestryModule)module, handler -> handler.registerSprites(event)));
    }

    @SubscribeEvent
    public void handleSprites(TextureStitchEvent.Post event) {
        this.modules.forEach(module -> this.actOnHandler((BlankForestryModule)module, handler -> handler.handleSprites(event)));
    }

    @SubscribeEvent
    public void bakeModels(ModelBakeEvent event) {
        this.modules.forEach(module -> this.actOnHandler((BlankForestryModule)module, handler -> handler.bakeModels(event)));
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        this.modules.forEach(module -> this.actOnHandler((BlankForestryModule)module, handler -> handler.registerModels(event)));
    }

    @SubscribeEvent
    public void setupClient(FMLClientSetupEvent event) {
        this.modules.forEach(module -> this.actOnHandler((BlankForestryModule)module, handler -> handler.setupClient(event)));
    }

    private void actOnHandler(BlankForestryModule module, Consumer<IClientModuleHandler> actor) {
        ISidedModuleHandler handler = module.getModuleHandler();
        if (!(handler instanceof IClientModuleHandler)) {
            return;
        }
        IClientModuleHandler clientHandler = (IClientModuleHandler)handler;
        actor.accept(clientHandler);
    }
}

