/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules;

import forestry.api.modules.IForestryModule;
import forestry.core.IPickupHandler;
import forestry.core.IResupplyHandler;
import forestry.core.ISaveEventHandler;
import forestry.core.ItemGroupForestry;
import forestry.core.network.IPacketRegistry;
import forestry.core.utils.Log;
import forestry.modules.BlankForestryModule;
import forestry.modules.ForestryPluginUtil;
import forestry.modules.ModuleManager;
import forestry.modules.features.FeatureType;
import forestry.modules.features.IModFeature;
import forestry.modules.features.ModFeatureRegistry;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CommonModuleHandler {
    protected final ModFeatureRegistry registry;
    protected final Set<BlankForestryModule> modules = new LinkedHashSet<BlankForestryModule>();
    protected final Set<IForestryModule> disabledModules = new LinkedHashSet<IForestryModule>();
    protected Stage stage = Stage.SETUP;

    public CommonModuleHandler() {
        this.registry = ModFeatureRegistry.get("forestry");
    }

    public void addModules(Collection<IForestryModule> modules, Collection<IForestryModule> disabledModules) {
        if (this.stage != Stage.SETUP) {
            throw new RuntimeException("Tried to register Modules outside of SETUP");
        }
        for (IForestryModule module : modules) {
            if (!(module instanceof BlankForestryModule)) continue;
            this.modules.add((BlankForestryModule)module);
        }
        this.disabledModules.addAll(disabledModules);
    }

    public Stage getStage() {
        return this.stage;
    }

    public void runSetup() {
        this.stage = Stage.SETUP;
        for (IForestryModule iForestryModule : this.modules) {
            Log.debug("Setup API Start: {}", iForestryModule);
            iForestryModule.setupAPI();
            Log.debug("Setup API Complete: {}", iForestryModule);
        }
        this.stage = Stage.SETUP_DISABLED;
        for (IForestryModule iForestryModule : this.disabledModules) {
            Log.debug("Disabled-Setup Start: {}", iForestryModule);
            iForestryModule.disabledSetupAPI();
            Log.debug("Disabled-Setup Complete: {}", iForestryModule);
        }
        this.stage = Stage.REGISTER;
    }

    public void createFeatures() {
        ItemGroupForestry.create();
        ForestryPluginUtil.loadFeatureProviders();
    }

    public void createObjects(BiPredicate<FeatureType, String> filter) {
        this.registry.createObjects(filter);
    }

    public Collection<IModFeature> getFeatures(FeatureType type) {
        return this.registry.getFeatures(type);
    }

    public Collection<IModFeature> getFeatures(Predicate<FeatureType> filter) {
        return this.registry.getFeatures(filter);
    }

    public <T extends IForgeRegistryEntry<T>> void registerObjects(RegistryEvent.Register<T> event) {
        this.registry.onRegister(event);
        this.registerObjects();
    }

    private void registerObjects() {
        for (IForestryModule iForestryModule : this.modules) {
            iForestryModule.registerObjects();
        }
    }

    public void registerGuiFactories() {
        for (IForestryModule iForestryModule : this.modules) {
            iForestryModule.registerGuiFactories();
        }
    }

    public void runPreInit() {
        this.stage = Stage.PRE_INIT;
        for (BlankForestryModule module : this.modules) {
            Log.debug("Pre-Init Start: {}", module);
            this.registerHandlers(module);
            module.preInit();
            Log.debug("Pre-Init Complete: {}", module);
        }
    }

    private void registerHandlers(BlankForestryModule module) {
        IResupplyHandler resupplyHandler;
        ISaveEventHandler saveHandler;
        IPickupHandler pickupHandler;
        Log.debug("Registering Handlers for Module: {}", module);
        IPacketRegistry packetRegistry = module.getPacketRegistry();
        if (packetRegistry != null) {
            this.registerPackages(packetRegistry);
        }
        if ((pickupHandler = module.getPickupHandler()) != null) {
            ModuleManager.pickupHandlers.add(pickupHandler);
        }
        if ((saveHandler = module.getSaveEventHandler()) != null) {
            ModuleManager.saveEventHandlers.add(saveHandler);
        }
        if ((resupplyHandler = module.getResupplyHandler()) != null) {
            ModuleManager.resupplyHandlers.add(resupplyHandler);
        }
    }

    protected void registerPackages(IPacketRegistry packetRegistry) {
        packetRegistry.registerPacketsServer();
    }

    public void runInit() {
        this.stage = Stage.INIT;
        for (IForestryModule iForestryModule : this.modules) {
            Log.debug("Init Start: {}", iForestryModule);
            iForestryModule.doInit();
            iForestryModule.registerRecipes();
            Log.debug("Init Complete: {}", iForestryModule);
        }
    }

    public void runClientInit() {
    }

    public void runPostInit() {
        this.stage = Stage.POST_INIT;
        for (IForestryModule iForestryModule : this.modules) {
            Log.debug("Post-Init Start: {}", iForestryModule);
            iForestryModule.postInit();
            Log.debug("Post-Init Complete: {}", iForestryModule);
        }
        this.stage = Stage.FINISHED;
    }

    public void runRegisterBackpacksAndCrates() {
        this.stage = Stage.BACKPACKS_CRATES;
    }

    public void runBookInit() {
        for (IForestryModule iForestryModule : this.modules) {
            Log.debug("Book Entry Registration Start: {}", iForestryModule);
            Log.debug("Book Entry Registration  Complete: {}", iForestryModule);
        }
    }

    public void processIMCMessages(Stream<InterModComms.IMCMessage> messages) {
        messages.forEach(m -> {
            for (BlankForestryModule module : this.modules) {
                if (module.processIMCMessage((InterModComms.IMCMessage)m)) break;
            }
        });
    }

    public static enum Stage {
        SETUP,
        SETUP_DISABLED,
        REGISTER,
        PRE_INIT,
        BACKPACKS_CRATES,
        INIT,
        POST_INIT,
        FINISHED;

    }
}

