/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules;

import forestry.api.modules.ForestryModule;
import forestry.api.modules.IForestryModule;
import forestry.core.utils.Log;
import forestry.modules.features.FeatureProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class ForestryPluginUtil {
    private ForestryPluginUtil() {
    }

    public static Map<String, List<IForestryModule>> getForestryModules() {
        List<IForestryModule> instances = ForestryPluginUtil.getInstances(ForestryModule.class, IForestryModule.class);
        LinkedHashMap<String, List<IForestryModule>> modules = new LinkedHashMap<String, List<IForestryModule>>();
        for (IForestryModule module : instances) {
            ForestryModule info = module.getClass().getAnnotation(ForestryModule.class);
            modules.computeIfAbsent(info.containerID(), k -> new ArrayList()).add(module);
        }
        return modules;
    }

    public static void loadFeatureProviders() {
        Type annotationType = Type.getType(FeatureProvider.class);
        List allScanData = ModList.get().getAllScanData();
        HashSet<String> pluginClassNames = new HashSet<String>();
        for (ModFileScanData scanData : allScanData) {
            Set annotationData = scanData.getAnnotations();
            for (ModFileScanData.AnnotationData data : annotationData) {
                if (!Objects.equals(data.getAnnotationType(), annotationType)) continue;
                pluginClassNames.add(data.getMemberName());
            }
        }
        for (String className : pluginClassNames) {
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException | ExceptionInInitializerError e) {
                Log.error("Failed to load: {}", className, e);
            }
        }
    }

    public static String getComment(IForestryModule module) {
        ForestryModule info = module.getClass().getAnnotation(ForestryModule.class);
        String comment = new TranslationTextComponent(info.unlocalizedDescription()).func_150261_e();
        Set<ResourceLocation> dependencies = module.getDependencyUids();
        if (!dependencies.isEmpty()) {
            Iterator<ResourceLocation> iDependencies = dependencies.iterator();
            StringBuilder builder = new StringBuilder(comment);
            builder.append("\n");
            builder.append("Dependencies: [ ");
            builder.append(iDependencies.next());
            while (iDependencies.hasNext()) {
                ResourceLocation uid = iDependencies.next();
                builder.append(", ").append(uid.toString());
            }
            builder.append(" ]");
            comment = builder.toString();
        }
        return comment;
    }

    private static <T> List<T> getInstances(Class annotationClass, Class<T> instanceClass) {
        Type annotationType = Type.getType((Class)annotationClass);
        List allScanData = ModList.get().getAllScanData();
        HashSet<String> pluginClassNames = new HashSet<String>();
        for (ModFileScanData scanData : allScanData) {
            Set annotationData = scanData.getAnnotations();
            for (ModFileScanData.AnnotationData data : annotationData) {
                if (!Objects.equals(data.getAnnotationType(), annotationType)) continue;
                pluginClassNames.add(data.getMemberName());
            }
        }
        ArrayList<T> instances = new ArrayList<T>();
        for (String className : pluginClassNames) {
            try {
                Class<?> asmClass = Class.forName(className);
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                T instance = asmInstanceClass.newInstance();
                instances.add(instance);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                Log.error("Failed to load: {}", className, e);
            }
        }
        return instances;
    }
}

