/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules.features;

import forestry.core.blocks.BlockBase;
import forestry.modules.features.FeatureType;
import forestry.modules.features.IBlockFeature;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItem;
import net.minecraft.state.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FeatureBlock<B extends Block, I extends BlockItem>
implements IBlockFeature<B, I> {
    protected final String moduleID;
    protected final String identifier;
    @Nullable
    private final Function<B, I> constructorItem;
    private final Supplier<B> constructorBlock;
    @Nullable
    private B block;
    @Nullable
    private I item;

    public FeatureBlock(String moduleID, String identifier, Supplier<B> constructorBlock, @Nullable Function<B, I> constructorItem) {
        this.moduleID = moduleID;
        this.identifier = identifier;
        this.constructorBlock = constructorBlock;
        this.constructorItem = constructorItem;
    }

    @Override
    public void setItem(I item) {
        this.item = item;
    }

    @Override
    public boolean hasItem() {
        return this.item != null;
    }

    @Override
    public boolean hasBlock() {
        return this.block != null;
    }

    @Override
    @Nullable
    public B getBlock() {
        return this.block;
    }

    @Override
    @Nullable
    public I getItem() {
        return this.item;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public String getTranslationKey() {
        return this.block == null ? "block.forestry:" + this.identifier : this.block.func_149739_a();
    }

    @Override
    public Supplier<B> getBlockConstructor() {
        return this.constructorBlock;
    }

    @Override
    public FeatureType getType() {
        return FeatureType.BLOCK;
    }

    @Override
    public String getModId() {
        return "forestry";
    }

    @Override
    public String getModuleId() {
        return this.moduleID;
    }

    @Override
    public void setBlock(B block) {
        this.block = block;
    }

    @Override
    public BlockState defaultState() {
        return this.block().func_176223_P();
    }

    @Override
    public <V extends Comparable<V>> BlockState with(Property<V> property, V value) {
        return (BlockState)this.defaultState().func_206870_a(property, value);
    }

    @Override
    @Nullable
    public Function<B, I> getItemBlockConstructor() {
        return this.constructorItem;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        if (this.block instanceof BlockBase) {
            ((BlockBase)this.block).clientSetup();
        }
    }
}

