/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules.features;

import forestry.modules.features.FeatureType;
import forestry.modules.features.IEntityTypeFeature;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;

public class FeatureEntityType<T extends Entity>
implements IEntityTypeFeature<T> {
    protected final String moduleID;
    protected final String identifier;
    protected final UnaryOperator<EntityType.Builder<T>> consumer;
    protected final Supplier<AttributeModifierMap.MutableAttribute> attributes;
    protected final EntityType.IFactory<T> factory;
    protected final EntityClassification classification;
    @Nullable
    private EntityType<T> entityType;

    public FeatureEntityType(String moduleID, String identifier, UnaryOperator<EntityType.Builder<T>> consumer, EntityType.IFactory<T> factory, EntityClassification classification, Supplier<AttributeModifierMap.MutableAttribute> attributes) {
        this.moduleID = moduleID;
        this.identifier = identifier;
        this.consumer = consumer;
        this.factory = factory;
        this.attributes = attributes;
        this.classification = classification;
    }

    @Override
    public void setEntityType(EntityType<T> entityType) {
        this.entityType = entityType;
    }

    @Override
    public AttributeModifierMap.MutableAttribute createAttributes() {
        return this.attributes.get();
    }

    @Override
    public EntityType.Builder<T> getEntityTypeConstructor() {
        return (EntityType.Builder)this.consumer.apply(EntityType.Builder.func_220322_a(this.factory, (EntityClassification)this.classification));
    }

    @Override
    public boolean hasEntityType() {
        return this.entityType != null;
    }

    @Override
    @Nullable
    public EntityType<T> getEntityType() {
        return this.entityType;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public FeatureType getType() {
        return FeatureType.ENTITY;
    }

    @Override
    public String getModId() {
        return "forestry";
    }

    @Override
    public String getModuleId() {
        return this.moduleID;
    }
}

