/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules.features;

import forestry.core.fluids.BlockForestryFluid;
import forestry.core.items.definitions.DrinkProperties;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureType;
import forestry.modules.features.FluidProperties;
import forestry.modules.features.IFeatureRegistry;
import forestry.modules.features.IFluidFeature;
import java.awt.Color;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class FeatureFluid
implements IFluidFeature {
    private final FeatureBlock<BlockForestryFluid, BlockItem> block;
    private final FluidProperties properties;
    private final String moduleID;
    private final String identifier;
    private final ForgeFlowingFluid.Properties internal;
    @Nullable
    private volatile FlowingFluid fluid;
    @Nullable
    private FlowingFluid flowing;

    public FeatureFluid(Builder builder) {
        this.moduleID = builder.moduleID;
        this.identifier = builder.identifier;
        this.block = builder.registry.block(() -> new BlockForestryFluid(this), "fluid_" + builder.identifier);
        this.properties = new FluidProperties(builder);
        ResourceLocation[] resources = this.properties().resources;
        FluidAttributes.Builder attributes = FluidAttributes.builder((ResourceLocation)resources[0], (ResourceLocation)resources[1]).density(this.properties().density).viscosity(this.properties().viscosity).temperature(this.properties().temperature);
        this.internal = new ForgeFlowingFluid.Properties(this::getFluid, this::getFlowing, attributes).block(this.block::getBlock).bucket(this.properties().bucket);
    }

    @Override
    public FeatureBlock<BlockForestryFluid, BlockItem> fluidBlock() {
        return this.block;
    }

    @Override
    public void setFluid(FlowingFluid fluid) {
        this.fluid = fluid;
    }

    @Override
    public void setFlowing(@Nullable FlowingFluid flowing) {
        this.flowing = flowing;
    }

    @Override
    public Supplier<FlowingFluid> getFluidConstructor(boolean flowing) {
        return () -> flowing ? new ForgeFlowingFluid.Flowing(this.internal) : new ForgeFlowingFluid.Source(this.internal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public FlowingFluid getFluid() {
        if (this.fluid == null) {
            FeatureFluid featureFluid = this;
            synchronized (featureFluid) {
                if (this.fluid == null) {
                    this.create();
                }
            }
        }
        return this.fluid;
    }

    @Override
    @Nullable
    public FlowingFluid getFlowing() {
        return this.flowing;
    }

    @Override
    public FluidProperties properties() {
        return this.properties;
    }

    @Override
    public boolean hasFlowing() {
        return this.flowing != null;
    }

    @Override
    public boolean hasFluid() {
        return this.fluid != null;
    }

    @Override
    public FeatureType getType() {
        return FeatureType.FLUID;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getModId() {
        return "forestry";
    }

    @Override
    public String getModuleId() {
        return this.moduleID;
    }

    public static class Builder {
        private final IFeatureRegistry registry;
        private final String moduleID;
        final String identifier;
        int density = 1000;
        int viscosity = 1000;
        int temperature = 295;
        Color particleColor = Color.WHITE;
        int flammability = 0;
        boolean flammable = false;
        @Nullable
        DrinkProperties properties = null;
        Supplier<Item> bucket = () -> Items.field_190931_a;

        public Builder(IFeatureRegistry registry, String moduleID, String identifier) {
            this.registry = registry;
            this.moduleID = moduleID;
            this.identifier = identifier;
        }

        public Builder flammable() {
            this.flammable = true;
            return this;
        }

        public Builder flammability(int flammability) {
            this.flammability = flammability;
            return this;
        }

        public Builder density(int density) {
            this.density = density;
            return this;
        }

        public Builder viscosity(int viscosity) {
            this.viscosity = viscosity;
            return this;
        }

        public Builder temperature(int temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder particleColor(Color color) {
            this.particleColor = color;
            return this;
        }

        public Builder bucket(Supplier<Item> bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder drinkProperties(int healAmount, float saturationModifier, int maxItemUseDuration) {
            this.properties = new DrinkProperties(healAmount, saturationModifier, maxItemUseDuration);
            return this;
        }

        public FeatureFluid create() {
            return this.registry.register(new FeatureFluid(this));
        }
    }
}

