/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules.features;

import forestry.api.core.IContainerTypeProvider;
import forestry.modules.features.IModFeature;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface IContainerTypeFeature<C extends Container>
extends IContainerTypeProvider<C>,
IModFeature {
    @Override
    default public void create() {
        ContainerType containerType = IForgeContainerType.create(this.getContainerFactory());
        containerType.setRegistryName(this.getModId(), this.getIdentifier());
        this.setContainerType(containerType);
    }

    default public <R extends IForgeRegistryEntry<R>> void register(RegistryEvent.Register<R> event) {
        IForgeRegistry registry = event.getRegistry();
        Class superType = registry.getRegistrySuperType();
        if (ContainerType.class.isAssignableFrom(superType) && this.hasContainerType()) {
            registry.register(this.containerType());
        }
    }

    @Override
    default public ContainerType<C> containerType() {
        ContainerType containerType = this.getContainerType();
        if (containerType == null) {
            throw new IllegalStateException("Called feature getter method before content creation.");
        }
        return containerType;
    }

    public void setContainerType(ContainerType<C> var1);

    public IContainerFactory<C> getContainerFactory();
}

