/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules.features;

import forestry.api.core.IBlockSubtype;
import forestry.api.core.IItemSubtype;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureBlockGroup;
import forestry.modules.features.FeatureBlockTable;
import forestry.modules.features.FeatureContainerType;
import forestry.modules.features.FeatureEntityType;
import forestry.modules.features.FeatureFluid;
import forestry.modules.features.FeatureItem;
import forestry.modules.features.FeatureItemGroup;
import forestry.modules.features.FeatureItemTable;
import forestry.modules.features.FeatureTileType;
import forestry.modules.features.FeatureType;
import forestry.modules.features.IModFeature;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.network.IContainerFactory;

public interface IFeatureRegistry {
    public <B extends Block, I extends BlockItem> FeatureBlock<B, I> block(Supplier<B> var1, String var2);

    public <B extends Block, I extends BlockItem> FeatureBlock<B, I> block(Supplier<B> var1, @Nullable Function<B, I> var2, String var3);

    public <B extends Block, S extends IBlockSubtype> FeatureBlockGroup.Builder<B, S> blockGroup(Function<S, B> var1, Class<? extends S> var2);

    public <B extends Block, S extends IBlockSubtype> FeatureBlockGroup.Builder<B, S> blockGroup(Function<S, B> var1, Collection<S> var2);

    public <B extends Block, S extends IBlockSubtype> FeatureBlockGroup.Builder<B, S> blockGroup(Function<S, B> var1, S[] var2);

    public <I extends Item> FeatureItem<I> item(Supplier<I> var1, String var2);

    public FeatureItem<Item> backpack(IBackpackDefinition var1, EnumBackpackType var2, String var3);

    public FeatureItem<Item> naturalistBackpack(IBackpackDefinition var1, String var2, ItemGroup var3, String var4);

    public <I extends Item, S extends IItemSubtype> FeatureItemGroup<I, S> itemGroup(Function<S, I> var1, String var2, S[] var3);

    public <I extends Item, S extends IItemSubtype> FeatureItemGroup.Builder<I, S> itemGroup(Function<S, I> var1, S[] var2);

    public <I extends Item, R extends IItemSubtype, C extends IItemSubtype> FeatureItemTable<I, R, C> itemTable(BiFunction<R, C, I> var1, R[] var2, C[] var3, String var4);

    public <I extends Item, R extends IItemSubtype, C extends IItemSubtype> FeatureItemTable.Builder<I, R, C> itemTable(BiFunction<R, C, I> var1, R[] var2, C[] var3);

    public <B extends Block, R extends IBlockSubtype, C extends IBlockSubtype> FeatureBlockTable.Builder<B, R, C> blockTable(BiFunction<R, C, B> var1, R[] var2, C[] var3);

    public <T extends TileEntity> FeatureTileType<T> tile(Supplier<T> var1, String var2, Supplier<Collection<? extends Block>> var3);

    public <C extends Container> FeatureContainerType<C> container(IContainerFactory<C> var1, String var2);

    public <E extends Entity> FeatureEntityType<E> entity(EntityType.IFactory<E> var1, EntityClassification var2, String var3);

    public <E extends Entity> FeatureEntityType<E> entity(EntityType.IFactory<E> var1, EntityClassification var2, String var3, UnaryOperator<EntityType.Builder<E>> var4);

    public <E extends Entity> FeatureEntityType<E> entity(EntityType.IFactory<E> var1, EntityClassification var2, String var3, UnaryOperator<EntityType.Builder<E>> var4, Supplier<AttributeModifierMap.MutableAttribute> var5);

    public FeatureFluid.Builder fluid(String var1);

    public void addRegistryListener(FeatureType var1, Consumer<RegistryEvent> var2);

    public <F extends IModFeature> F register(F var1);

    public Collection<IModFeature> getFeatures();

    public Collection<IModFeature> getFeatures(FeatureType var1);
}

