/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules.features;

import forestry.core.fluids.BlockForestryFluid;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FluidProperties;
import forestry.modules.features.IModFeature;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItem;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface IFluidFeature
extends IModFeature {
    public FeatureBlock<BlockForestryFluid, BlockItem> fluidBlock();

    default public Fluid apply(Fluid fluid) {
        return fluid;
    }

    public void setFluid(FlowingFluid var1);

    public void setFlowing(FlowingFluid var1);

    public Supplier<FlowingFluid> getFluidConstructor(boolean var1);

    @Nullable
    public FlowingFluid getFluid();

    @Nullable
    public FlowingFluid getFlowing();

    public FluidProperties properties();

    public boolean hasFluid();

    public boolean hasFlowing();

    default public FlowingFluid fluid() {
        FlowingFluid fluid = this.getFluid();
        if (fluid == null) {
            throw new IllegalStateException("Called feature getter method before content creation.");
        }
        return fluid;
    }

    default public FlowingFluid flowing() {
        FlowingFluid flowing = this.getFlowing();
        if (flowing == null) {
            throw new IllegalStateException("Called feature getter method before content creation.");
        }
        return flowing;
    }

    default public FluidStack fluidStack(int amount) {
        if (this.hasFluid()) {
            return new FluidStack((Fluid)this.fluid(), amount);
        }
        return FluidStack.EMPTY;
    }

    default public FluidStack fluidStack() {
        return this.fluidStack(1000);
    }

    @Override
    default public void create() {
        FlowingFluid fluid = this.getFluidConstructor(false).get();
        FlowingFluid flowing = this.getFluidConstructor(true).get();
        fluid.setRegistryName(this.getModId(), this.getIdentifier());
        flowing.setRegistryName(this.getModId(), this.getIdentifier() + "_flowing");
        this.setFluid(fluid);
        this.setFlowing(flowing);
    }

    @Override
    default public <T extends IForgeRegistryEntry<T>> void register(RegistryEvent.Register<T> event) {
        IForgeRegistry registry = event.getRegistry();
        Class superType = registry.getRegistrySuperType();
        if (Fluid.class.isAssignableFrom(superType)) {
            registry.register((IForgeRegistryEntry)this.fluid());
            registry.register((IForgeRegistryEntry)this.flowing());
        }
    }
}

