/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules.features;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IBlockSubtype;
import forestry.api.core.IFeatureSubtype;
import forestry.api.core.IItemSubtype;
import forestry.api.modules.ForestryModule;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureBlockGroup;
import forestry.modules.features.FeatureBlockTable;
import forestry.modules.features.FeatureContainerType;
import forestry.modules.features.FeatureCreationEvent;
import forestry.modules.features.FeatureEntityType;
import forestry.modules.features.FeatureFluid;
import forestry.modules.features.FeatureItem;
import forestry.modules.features.FeatureItemGroup;
import forestry.modules.features.FeatureItemTable;
import forestry.modules.features.FeatureTileType;
import forestry.modules.features.FeatureType;
import forestry.modules.features.IFeatureRegistry;
import forestry.modules.features.IModFeature;
import forestry.modules.features.RegisterFeatureEvent;
import forestry.storage.ModuleBackpacks;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModFeatureRegistry {
    private static final HashMap<String, ModFeatureRegistry> registries = new LinkedHashMap<String, ModFeatureRegistry>();
    private final HashMap<String, ModuleFeatures> modules = new LinkedHashMap<String, ModuleFeatures>();
    private final String modId;

    public static ModFeatureRegistry get(String modId) {
        return registries.computeIfAbsent(modId, ModFeatureRegistry::new);
    }

    public static Map<String, ModFeatureRegistry> getRegistries() {
        return registries;
    }

    public static IFeatureRegistry get(Class<?> clazz) {
        ForestryModule module = clazz.getAnnotation(ForestryModule.class);
        if (module != null) {
            return ModFeatureRegistry.get(module.containerID()).getRegistry(module.moduleID());
        }
        return ModFeatureRegistry.get("forestry").getRegistry("core");
    }

    public IFeatureRegistry getRegistry(String moduleID) {
        return this.modules.computeIfAbsent(moduleID, ModuleFeatures::new);
    }

    private ModFeatureRegistry(String modId) {
        this.modId = modId;
    }

    public static void fireEvent() {
        RegisterFeatureEvent event = new RegisterFeatureEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public void register(IModFeature feature) {
        this.modules.computeIfAbsent(feature.getModuleId(), ModuleFeatures::new).register(feature);
    }

    public boolean isEnabled(IModFeature feature) {
        return ForestryAPI.moduleManager.isModuleEnabled(this.modId, feature.getModuleId());
    }

    public void createObjects(BiPredicate<FeatureType, String> filter) {
        for (FeatureType type : FeatureType.values()) {
            this.modules.values().forEach(features -> {
                if (filter.test(type, ((ModuleFeatures)features).moduleID)) {
                    features.createObjects(type);
                    MinecraftForge.EVENT_BUS.post((Event)new FeatureCreationEvent(this.modId, ((ModuleFeatures)features).moduleID, type));
                }
            });
        }
    }

    public Collection<IModFeature> getFeatures(FeatureType type) {
        return this.modules.values().stream().flatMap(module -> module.getFeatures(type).stream()).collect(Collectors.toSet());
    }

    public Collection<IModFeature> getFeatures(Predicate<FeatureType> filter) {
        return Stream.of(FeatureType.values()).filter(filter).flatMap(type -> this.modules.values().stream().flatMap(module -> module.getFeatures((FeatureType)((Object)type)).stream())).collect(Collectors.toSet());
    }

    public <T extends IForgeRegistryEntry<T>> void onRegister(RegistryEvent.Register<T> event) {
        for (ModuleFeatures features : this.modules.values()) {
            features.onRegister(event);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        for (ModuleFeatures features : this.modules.values()) {
            features.clientSetup();
        }
    }

    private static class ModuleFeatures
    implements IFeatureRegistry {
        private final HashMap<String, IModFeature> featureById = new LinkedHashMap<String, IModFeature>();
        private final Multimap<FeatureType, IModFeature> featureByType = LinkedListMultimap.create();
        private final Multimap<FeatureType, Consumer<RegistryEvent>> registryListeners = LinkedListMultimap.create();
        private final String moduleID;

        public ModuleFeatures(String moduleID) {
            this.moduleID = moduleID;
        }

        @Override
        public <B extends Block, I extends BlockItem> FeatureBlock<B, I> block(Supplier<B> constructor, String identifier) {
            return this.block(constructor, null, identifier);
        }

        @Override
        public <B extends Block, I extends BlockItem> FeatureBlock<B, I> block(Supplier<B> constructor, @Nullable Function<B, I> itemConstructor, String identifier) {
            return this.register(new FeatureBlock<B, I>(this.moduleID, identifier, constructor, itemConstructor));
        }

        @Override
        public <B extends Block, S extends IBlockSubtype> FeatureBlockGroup.Builder<B, S> blockGroup(Function<S, B> constructor, Class<? extends S> typeClass) {
            return new FeatureBlockGroup.Builder<B, S>(this, constructor);
        }

        @Override
        public <B extends Block, S extends IBlockSubtype> FeatureBlockGroup.Builder<B, S> blockGroup(Function<S, B> constructor, Collection<S> types) {
            return (FeatureBlockGroup.Builder)new FeatureBlockGroup.Builder<B, S>(this, constructor).types(types);
        }

        @Override
        public <B extends Block, S extends IBlockSubtype> FeatureBlockGroup.Builder<B, S> blockGroup(Function<S, B> constructor, S[] types) {
            return (FeatureBlockGroup.Builder)new FeatureBlockGroup.Builder<B, S>(this, constructor).types((IFeatureSubtype[])types);
        }

        @Override
        public <I extends Item> FeatureItem<I> item(Supplier<I> constructor, String identifier) {
            return this.register(new FeatureItem<I>(this.moduleID, identifier, constructor));
        }

        @Override
        public FeatureItem<Item> backpack(IBackpackDefinition definition, EnumBackpackType type, String identifier) {
            return this.item(() -> ModuleBackpacks.BACKPACK_INTERFACE.createBackpack(definition, type), identifier);
        }

        @Override
        public FeatureItem<Item> naturalistBackpack(IBackpackDefinition definition, String rootUid, ItemGroup tab, String identifier) {
            return this.item(() -> ModuleBackpacks.BACKPACK_INTERFACE.createNaturalistBackpack(definition, rootUid, tab), identifier);
        }

        @Override
        public <I extends Item, S extends IItemSubtype> FeatureItemGroup<I, S> itemGroup(Function<S, I> constructor, String identifier, S[] subTypes) {
            return (FeatureItemGroup)this.itemGroup(constructor, (IItemSubtype[])subTypes).identifier(identifier).create();
        }

        @Override
        public <I extends Item, S extends IItemSubtype> FeatureItemGroup.Builder<I, S> itemGroup(Function<S, I> constructor, S[] subTypes) {
            return (FeatureItemGroup.Builder)new FeatureItemGroup.Builder<I, S>(this, constructor).types((IFeatureSubtype[])subTypes);
        }

        @Override
        public <I extends Item, R extends IItemSubtype, C extends IItemSubtype> FeatureItemTable<I, R, C> itemTable(BiFunction<R, C, I> constructor, R[] rowTypes, C[] columnTypes, String identifier) {
            return (FeatureItemTable)this.itemTable(constructor, (IItemSubtype[])rowTypes, (IItemSubtype[])columnTypes).identifier(identifier).create();
        }

        @Override
        public <I extends Item, R extends IItemSubtype, C extends IItemSubtype> FeatureItemTable.Builder<I, R, C> itemTable(BiFunction<R, C, I> constructor, R[] rowTypes, C[] columnTypes) {
            return (FeatureItemTable.Builder)new FeatureItemTable.Builder<I, R, C>(this, constructor).rowTypes((IFeatureSubtype[])rowTypes).columnTypes((IFeatureSubtype[])columnTypes);
        }

        @Override
        public <B extends Block, R extends IBlockSubtype, C extends IBlockSubtype> FeatureBlockTable.Builder<B, R, C> blockTable(BiFunction<R, C, B> constructor, R[] rowTypes, C[] columnTypes) {
            return (FeatureBlockTable.Builder)new FeatureBlockTable.Builder<B, R, C>(this, constructor).rowTypes((IFeatureSubtype[])rowTypes).columnTypes((IFeatureSubtype[])columnTypes);
        }

        @Override
        public FeatureFluid.Builder fluid(String identifier) {
            return new FeatureFluid.Builder(this, this.moduleID, identifier);
        }

        @Override
        public void addRegistryListener(FeatureType type, Consumer<RegistryEvent> listener) {
            this.registryListeners.put((Object)type, listener);
        }

        @Override
        public <F extends IModFeature> F register(F feature) {
            this.featureById.put(feature.getIdentifier(), feature);
            this.featureByType.put((Object)feature.getType(), feature);
            return feature;
        }

        @Override
        public <T extends TileEntity> FeatureTileType<T> tile(Supplier<T> constructor, String identifier, Supplier<Collection<? extends Block>> validBlocks) {
            return this.register(new FeatureTileType<T>(this.moduleID, identifier, constructor, validBlocks));
        }

        @Override
        public <C extends Container> FeatureContainerType<C> container(IContainerFactory<C> factory, String identifier) {
            return this.register(new FeatureContainerType<C>(this.moduleID, identifier, factory));
        }

        @Override
        public <E extends Entity> FeatureEntityType<E> entity(EntityType.IFactory<E> factory, EntityClassification classification, String identifier) {
            return this.entity(factory, classification, identifier, builder -> builder);
        }

        @Override
        public <E extends Entity> FeatureEntityType<E> entity(EntityType.IFactory<E> factory, EntityClassification classification, String identifier, UnaryOperator<EntityType.Builder<E>> consumer) {
            return this.entity(factory, classification, identifier, consumer, LivingEntity::func_233639_cI_);
        }

        @Override
        public <E extends Entity> FeatureEntityType<E> entity(EntityType.IFactory<E> factory, EntityClassification classification, String identifier, UnaryOperator<EntityType.Builder<E>> consumer, Supplier<AttributeModifierMap.MutableAttribute> attributes) {
            return this.register(new FeatureEntityType(this.moduleID, identifier, consumer, factory, classification, attributes));
        }

        public IModFeature getFeature(String identifier) {
            return this.featureById.get(identifier);
        }

        @Override
        public Collection<IModFeature> getFeatures() {
            return this.featureById.values();
        }

        @Override
        public Collection<IModFeature> getFeatures(FeatureType type) {
            return this.featureByType.get((Object)type);
        }

        public void createObjects(FeatureType type) {
            for (IModFeature feature : this.featureByType.get((Object)type)) {
                this.createObject(feature);
            }
        }

        private void createObject(IModFeature feature) {
            if (!feature.isEnabled()) {
                return;
            }
            feature.create();
        }

        public <T extends IForgeRegistryEntry<T>> void onRegister(RegistryEvent.Register<T> event) {
            for (FeatureType type : FeatureType.values()) {
                for (IModFeature feature : this.featureByType.get((Object)type)) {
                    feature.register(event);
                }
                if (!type.superType.isAssignableFrom(event.getRegistry().getRegistrySuperType())) continue;
                this.registryListeners.get((Object)type).forEach(listener -> listener.accept(event));
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void clientSetup() {
            for (IModFeature feature : this.featureByType.values()) {
                feature.clientSetup();
            }
        }
    }
}

