/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting;

import forestry.api.core.ILocatable;
import forestry.api.genetics.filter.IFilterLogic;
import forestry.api.genetics.filter.IFilterRegistry;
import forestry.api.genetics.filter.IFilterRuleType;
import forestry.sorting.DefaultFilterRuleType;
import forestry.sorting.FilterLogic;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import javax.annotation.Nullable;

public class FilterRegistry
implements IFilterRegistry {
    private static final Comparator<IFilterRuleType> FILTER_COMPARATOR = (f, s) -> f.getUID().compareToIgnoreCase(s.getUID());
    private final HashMap<String, IFilterRuleType> filterByName = new LinkedHashMap<String, IFilterRuleType>();
    private final HashMap<String, Integer> filterIDByName = new LinkedHashMap<String, Integer>();
    private final HashMap<Integer, IFilterRuleType> filterByID = new LinkedHashMap<Integer, IFilterRuleType>();

    @Override
    public void registerFilter(IFilterRuleType rule) {
        if (!this.filterByID.isEmpty()) {
            return;
        }
        this.filterByName.put(rule.getUID(), rule);
    }

    public void init() {
        LinkedList<IFilterRuleType> rules = new LinkedList<IFilterRuleType>(this.filterByName.values());
        rules.sort(FILTER_COMPARATOR);
        for (int i = 0; i < rules.size(); ++i) {
            IFilterRuleType rule = (IFilterRuleType)rules.get(i);
            this.filterIDByName.put(rule.getUID(), i);
            this.filterByID.put(i, rule);
        }
    }

    @Override
    public Collection<IFilterRuleType> getRules() {
        return this.filterByName.values();
    }

    @Override
    public IFilterRuleType getDefaultRule() {
        return DefaultFilterRuleType.CLOSED;
    }

    @Override
    @Nullable
    public IFilterRuleType getRule(String uid) {
        return this.filterByName.get(uid);
    }

    @Override
    public int getId(IFilterRuleType rule) {
        return this.filterIDByName.get(rule.getUID());
    }

    @Override
    public IFilterLogic createLogic(ILocatable locatable, IFilterLogic.INetworkHandler networkHandler) {
        return new FilterLogic(locatable, networkHandler);
    }

    @Override
    @Nullable
    public IFilterRuleType getRule(int id) {
        return this.filterByID.get(id);
    }
}

