/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.gui;

import forestry.core.gui.ContainerTile;
import forestry.core.tiles.TileUtil;
import forestry.sorting.features.SortingContainers;
import forestry.sorting.gui.SlotFilterFacing;
import forestry.sorting.gui.SlotGeneticFilter;
import forestry.sorting.network.packets.PacketGuiFilterUpdate;
import forestry.sorting.tiles.IFilterContainer;
import forestry.sorting.tiles.TileGeneticFilter;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.IBlockReader;

public class ContainerGeneticFilter
extends ContainerTile<TileGeneticFilter> {
    private final IFilterContainer container;
    private boolean guiNeedsUpdate = true;

    public static ContainerGeneticFilter fromNetwork(int windowId, PlayerInventory inv, PacketBuffer data) {
        TileGeneticFilter tile = TileUtil.getTile((IBlockReader)inv.field_70458_d.field_70170_p, data.func_179259_c(), TileGeneticFilter.class);
        return new ContainerGeneticFilter(windowId, inv, tile);
    }

    public ContainerGeneticFilter(int windowId, PlayerInventory playerInventory, IFilterContainer container) {
        super(windowId, SortingContainers.GENETIC_FILTER.containerType(), container.getTileEntity());
        this.container = container;
        this.addInventory(playerInventory, 26, 140);
    }

    protected void addInventory(PlayerInventory playerInventory, int xInv, int yInv) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.func_75146_a(new SlotGeneticFilter((IInventory)playerInventory, column + row * 9 + 9, xInv + column * 18, yInv + row * 18));
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.func_75146_a(new SlotGeneticFilter((IInventory)playerInventory, column, xInv + column * 18, yInv + 58));
        }
        IInventory buffer = this.container.getBuffer();
        if (buffer != null) {
            for (int x = 0; x < 6; ++x) {
                this.func_75146_a(new SlotFilterFacing(buffer, x, 8, 18 + x * 18));
            }
        }
    }

    public void setGuiNeedsUpdate(boolean guiNeedsUpdate) {
        this.guiNeedsUpdate = guiNeedsUpdate;
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        if (this.guiNeedsUpdate) {
            PacketGuiFilterUpdate packet = new PacketGuiFilterUpdate(this.container);
            this.sendPacketToListeners(packet);
            this.guiNeedsUpdate = false;
        }
    }

    public boolean hasSameTile(ContainerGeneticFilter openContainer) {
        return this.tile == openContainer.tile;
    }
}

