/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.gui.widgets;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.api.core.tooltips.ToolTip;
import forestry.api.genetics.alleles.AlleleManager;
import forestry.api.genetics.filter.IFilterLogic;
import forestry.api.genetics.filter.IFilterRuleType;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.utils.SoundUtil;
import forestry.sorting.gui.GuiGeneticFilter;
import forestry.sorting.gui.ISelectableProvider;
import forestry.sorting.gui.widgets.SelectionWidget;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class RuleWidget
extends Widget
implements ISelectableProvider<IFilterRuleType> {
    private static final ImmutableSet<IFilterRuleType> ENTRIES = RuleWidget.createEntries();
    private final Direction facing;
    private final GuiGeneticFilter gui;

    public RuleWidget(WidgetManager manager, int xPos, int yPos, Direction facing, GuiGeneticFilter gui) {
        super(manager, xPos, yPos);
        this.facing = facing;
        this.gui = gui;
    }

    @Override
    public void draw(MatrixStack transform, int startY, int startX) {
        int x = this.xPos + startX;
        int y = this.yPos + startY;
        IFilterLogic logic = this.gui.getLogic();
        IFilterRuleType rule = logic.getRule(this.facing);
        this.draw(this.manager.gui, rule, transform, y, x);
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        if (this.gui.selection.isSame(this)) {
            textureManager.func_110577_a(SelectionWidget.TEXTURE);
            this.gui.func_238474_b_(transform, x - 1, y - 1, 212, 0, 18, 18);
        }
    }

    @Override
    public Collection<IFilterRuleType> getEntries() {
        return ENTRIES;
    }

    @Override
    public void draw(GuiForestry gui, IFilterRuleType selectable, MatrixStack transform, int y, int x) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(selectable.getTextureMap());
        TextureAtlasSprite sprite = selectable.getSprite();
        AbstractGui.func_238470_a_((MatrixStack)transform, (int)x, (int)y, (int)gui.func_230927_p_(), (int)16, (int)16, (TextureAtlasSprite)sprite);
    }

    @Override
    public ITextComponent getName(IFilterRuleType selectable) {
        return new TranslationTextComponent("for.gui.filter." + selectable.getUID());
    }

    @Override
    public void onSelect(IFilterRuleType selectable) {
        IFilterLogic logic = this.gui.getLogic();
        if (logic.setRule(this.facing, selectable)) {
            logic.sendToServer(this.facing, selectable);
        }
        if (this.gui.selection.isSame(this)) {
            this.gui.onModuleClick(this);
        }
        SoundUtil.playButtonClick();
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 1) {
            this.onSelect(AlleleManager.filterRegistry.getDefaultRule());
        } else {
            SoundUtil.playButtonClick();
            this.gui.onModuleClick(this);
        }
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        IFilterLogic logic = this.gui.getLogic();
        IFilterRuleType rule = logic.getRule(this.facing);
        ToolTip tooltip = new ToolTip();
        tooltip.add(this.getName(rule));
        return tooltip;
    }

    private static ImmutableSet<IFilterRuleType> createEntries() {
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (IFilterRuleType rule : AlleleManager.filterRegistry.getRules()) {
            entries.add((Object)rule);
        }
        return entries.build();
    }
}

