/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.network.packets;

import forestry.api.genetics.GeneticCapabilities;
import forestry.api.genetics.filter.IFilterLogic;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketHandlerServer;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdServer;
import forestry.core.tiles.TileUtil;
import genetics.api.alleles.IAllele;
import genetics.utils.AlleleUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.LazyOptional;

public class PacketFilterChangeGenome
extends ForestryPacket
implements IForestryPacketServer {
    private final BlockPos pos;
    private final Direction facing;
    private final short index;
    private final boolean active;
    @Nullable
    private final IAllele allele;

    public PacketFilterChangeGenome(BlockPos pos, Direction facing, short index, boolean active, @Nullable IAllele allele) {
        this.pos = pos;
        this.facing = facing;
        this.index = index;
        this.active = active;
        this.allele = allele;
    }

    @Override
    protected void writeData(PacketBufferForestry data) {
        data.func_179255_a(this.pos);
        data.writeShort(this.facing.func_176745_a());
        data.writeShort(this.index);
        data.writeBoolean(this.active);
        if (this.allele != null) {
            data.writeBoolean(true);
            data.func_180714_a(this.allele.getRegistryName().toString());
        } else {
            data.writeBoolean(false);
        }
    }

    @Override
    public PacketIdServer getPacketId() {
        return PacketIdServer.FILTER_CHANGE_GENOME;
    }

    public static class Handler
    implements IForestryPacketHandlerServer {
        @Override
        public void onPacketData(PacketBufferForestry data, ServerPlayerEntity player) {
            BlockPos pos = data.func_179259_c();
            Direction facing = Direction.func_82600_a((int)data.readShort());
            short index = data.readShort();
            boolean active = data.readBoolean();
            IAllele allele = data.readBoolean() ? (IAllele)AlleleUtils.getAlleleOrNull(data.func_218666_n()) : null;
            LazyOptional<IFilterLogic> logic = TileUtil.getInterface(player.field_70170_p, pos, GeneticCapabilities.FILTER_LOGIC, null);
            logic.ifPresent(l -> {
                if (l.setGenomeFilter(facing, index, active, allele)) {
                    l.getNetworkHandler().sendToPlayers((IFilterLogic)l, player.func_71121_q(), (PlayerEntity)player);
                }
            });
        }
    }
}

